/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_prepend"}, parameter="(Array array,Object element)", descriptions={"- Return \"\" if 'array' is null;", "- Return the result of appending an element to the beginning of the array."}, examples={"array_prepend(array(4,3),3) = [3, 4, 3]"})
public class ArrayPrependFunction
implements ValueParser {
    private final ValueParser arrayParser;
    private ValueParser elementParser;

    public ArrayPrependFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.arrayParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() > 1) {
            this.elementParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object elementObj = this.elementParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>(array.size() + 1);
            result.add(elementObj);
            result.addAll(array);
            return result;
        }
        return null;
    }
}

