/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.collection;

import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="collection", names={"array_remove"}, parameter="(Array array,Object element)", descriptions={"- Return \"\" if 'array' is null;", "- Return the result of removing all elements that equal to 'element' from 'array'."}, examples={"array_remove(array('he',7,'xxd'),'he') = [7, xxd]"})
public class ArrayRemoveFunction
implements ValueParser {
    private final ValueParser arrayParser;
    private ValueParser needleParser;

    public ArrayRemoveFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.arrayParser = OperatorTools.buildParser((Expression)expressions.get(0));
        if (expressions.size() > 1) {
            this.needleParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object arrayObj = this.arrayParser.parse(sourceData, rowIndex, context);
        Object needleObj = this.needleParser.parse(sourceData, rowIndex, context);
        if (arrayObj == null) {
            return null;
        }
        if (arrayObj instanceof ArrayList) {
            ArrayList array = (ArrayList)arrayObj;
            if (array.isEmpty()) {
                return null;
            }
            array.removeIf(element -> element == null && needleObj == null || element != null && element.equals(needleObj));
            return array;
        }
        return null;
    }
}

