/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.condition;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="condition", names={"nullif", "null_if"}, parameter="(Expr expr1, Expr expr2)", descriptions={"- Return \"\" if 'expr1' = 'expr2' is true;", "- Return 'expr1' otherwise."}, examples={"nullif(5, 3) = 5"})
public class NullIfFunction
implements ValueParser {
    private final ValueParser firstExprParser;
    private final ValueParser secondExprParser;

    public NullIfFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.firstExprParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.secondExprParser = OperatorTools.buildParser((Expression)expressions.get(1));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object firstExprObj = this.firstExprParser.parse(sourceData, rowIndex, context);
        if (firstExprObj == null) {
            return null;
        }
        Object secondExprObj = this.secondExprParser.parse(sourceData, rowIndex, context);
        if (secondExprObj == null) {
            return firstExprObj;
        }
        int cmp = OperatorTools.compareValue((Comparable)firstExprObj, (Comparable)secondExprObj);
        return cmp == 0 ? null : firstExprObj;
    }
}

