/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regex", "similar", "regexp_like"}, parameter="(String str, String regexp)", descriptions={"- Return \"\" if any of the arguments are NULL or invalid;", "- Return TRUE if any (possibly empty) substring of 'str' matches the Java regular expression 'regexp'."}, examples={"regexp(\"The quick brown fox\", \"quick\") = true", "regexp(\"The quick brown fox\", \"cold\") = false"})
public class RegexpFunction
implements ValueParser {
    private ValueParser inputParser;
    private ValueParser patternParser;

    public RegexpFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() == 2) {
            this.inputParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternParser = OperatorTools.buildParser((Expression)expressions.get(1));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.inputParser == null || this.patternParser == null) {
            return null;
        }
        String inputString = OperatorTools.parseString(this.inputParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternParser.parse(sourceData, rowIndex, context));
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(inputString);
        return matcher.find();
    }
}

