/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"rpad"}, parameter="(String str)", descriptions={"- Return \"\" if any of the three parameters is NULL or 'len' is less than 0;", "- Return the substring of 's1' with subscripts in the range of [0, 'len') if 'len' is less than or equal to the length of 's1';", "- Return \"\" if 's2' is \"\" and 'len' is longer than the length of 's1';", "- Return the result string of padding string 's2' at the end of string 's1' to make the length of the string 'len' if 's2' is not \"\"."}, examples={"rpad('he',1,'xxd') = \"h\"", "rpad('he',7,'') = \"\""})
public class RpadFunction
implements ValueParser {
    private final ValueParser leftStringParser;
    private final ValueParser lengthParser;
    private final ValueParser rightStringParser;

    public RpadFunction(Function expr) {
        List expressions = expr.getParameters().getExpressions();
        this.leftStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
        this.lengthParser = OperatorTools.buildParser((Expression)expressions.get(1));
        this.rightStringParser = OperatorTools.buildParser((Expression)expressions.get(2));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object leftStringObj = this.leftStringParser.parse(sourceData, rowIndex, context);
        Object lengthObj = this.lengthParser.parse(sourceData, rowIndex, context);
        Object rightStringObj = this.rightStringParser.parse(sourceData, rowIndex, context);
        if (leftStringObj == null || lengthObj == null || rightStringObj == null) {
            return null;
        }
        int len = Integer.parseInt(OperatorTools.parseString(lengthObj));
        if (len < 0) {
            return null;
        }
        String leftStr = OperatorTools.parseString(leftStringObj);
        if (len <= leftStr.length()) {
            return leftStr.substring(0, len);
        }
        String rightStr = OperatorTools.parseString(rightStringObj);
        if (rightStr.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(len);
        builder.append(leftStr);
        while (builder.length() < len) {
            builder.append(rightStr);
        }
        return builder.substring(0, len);
    }
}

