/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"space"}, parameter="(Integer N)", descriptions={"- Return \"\" if 'N' is NULL or less than or equal to 0;", "- Return a string consisting of 'N' space characters."}, examples={"space(5) = \"     \""})
public class SpaceFunction
implements ValueParser {
    private final ValueParser cntParser;

    public SpaceFunction(Function expr) {
        this.cntParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object cntObj = this.cntParser.parse(sourceData, rowIndex, context);
        if (cntObj == null) {
            return null;
        }
        int cnt = OperatorTools.parseBigDecimal(cntObj).intValue();
        if (cnt <= 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(cnt);
        for (int i = 0; i < cnt; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }
}

