/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.operator;

import net.sf.jsqlparser.expression.operators.relational.Between;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.operator.TransformOperator;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformOperator(values={Between.class})
public class BetweenAndOperator
implements ExpressionOperator {
    private final ValueParser left;
    private final ValueParser start;
    private final ValueParser end;
    private final boolean isNot;

    public BetweenAndOperator(Between expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        this.start = OperatorTools.buildParser(expr.getBetweenExpressionStart());
        this.end = OperatorTools.buildParser(expr.getBetweenExpressionEnd());
        this.isNot = expr.isNot();
    }

    @Override
    public boolean check(SourceData sourceData, int rowIndex, Context context) {
        Comparable leftValue = (Comparable)this.left.parse(sourceData, rowIndex, context);
        Comparable startValue = (Comparable)this.start.parse(sourceData, rowIndex, context);
        Comparable endValue = (Comparable)this.end.parse(sourceData, rowIndex, context);
        boolean result = OperatorTools.compareValue(leftValue, startValue) >= 0 && OperatorTools.compareValue(leftValue, endValue) <= 0;
        return this.isNot != result;
    }
}

