/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.math.BigInteger;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseLeftShift;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TransformParser(values={BitwiseLeftShift.class})
public class BitwiseLeftShiftParser
implements ValueParser {
    private static final Logger log = LoggerFactory.getLogger(BitwiseLeftShiftParser.class);
    private final ValueParser left;
    private final ValueParser right;

    public BitwiseLeftShiftParser(BitwiseLeftShift expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        this.right = OperatorTools.buildParser(expr.getRightExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        try {
            Object leftObj = this.left.parse(sourceData, rowIndex, context);
            Object rightObj = this.right.parse(sourceData, rowIndex, context);
            if (leftObj == null || rightObj == null) {
                return null;
            }
            BigInteger leftValue = OperatorTools.parseBigDecimal(leftObj).toBigInteger();
            String unsignedRight = Long.toUnsignedString(OperatorTools.parseBigDecimal(rightObj).longValue());
            int cmp = new BigInteger(unsignedRight).compareTo(new BigInteger("65"));
            if (cmp >= 0) {
                return Long.toUnsignedString(leftValue.shiftLeft(65).longValue());
            }
            return Long.toUnsignedString(leftValue.shiftLeft(Integer.parseInt(unsignedRight)).longValue());
        }
        catch (Exception e) {
            log.error("Value parsing failed", (Throwable)e);
            return null;
        }
    }
}

