/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.utils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.types.Row;
import org.apache.inlong.sort.formats.base.RowDataToFieldConverters;

public class RowToFieldDataUtils {
    private static final long serialVersionUID = 1L;

    public static RowFieldConverter createNullableRowFieldConverter(LogicalType fieldType) {
        RowFieldConverter fieldConverter = RowToFieldDataUtils.createRowFieldConverter(fieldType);
        return (row, pos) -> {
            if (row.isNullAt(pos)) {
                return null;
            }
            return fieldConverter.convert(row, pos);
        };
    }

    private static RowFieldConverter createRowFieldConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return (row, pos) -> null;
            }
            case BOOLEAN: {
                return RowData::getBoolean;
            }
            case TINYINT: {
                return RowData::getByte;
            }
            case SMALLINT: {
                return RowData::getShort;
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return RowData::getInt;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return RowData::getLong;
            }
            case FLOAT: {
                return RowData::getFloat;
            }
            case DOUBLE: {
                return RowData::getDouble;
            }
            case CHAR: 
            case VARCHAR: {
                return (row, pos) -> row.getString(pos).toString();
            }
            case BINARY: 
            case VARBINARY: {
                return RowData::getBinary;
            }
            case DATE: {
                return (row, pos) -> RowToFieldDataUtils.convertDate(row.getLong(pos));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (row, pos) -> RowToFieldDataUtils.convertTime(row.getInt(pos));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)fieldType).getPrecision();
                return (row, pos) -> RowToFieldDataUtils.convertTimestamp(row.getTimestamp(pos, timestampPrecision));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int zonedTimestampPrecision = ((LocalZonedTimestampType)fieldType).getPrecision();
                return (row, pos) -> RowToFieldDataUtils.convertTimestamp(row.getTimestamp(pos, zonedTimestampPrecision));
            }
            case DECIMAL: {
                return RowToFieldDataUtils.createDecimalRowFieldConverter((DecimalType)fieldType);
            }
            case ARRAY: {
                return RowToFieldDataUtils.createArrayRowFieldConverter((ArrayType)fieldType);
            }
            case ROW: {
                return RowToFieldDataUtils.createRowRowFieldConverter((RowType)fieldType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private static ArrayElementConverter createNullableArrayElementConverter(LogicalType fieldType) {
        ArrayElementConverter elementConverter = RowToFieldDataUtils.createArrayElementConverter(fieldType);
        return (array, pos) -> {
            if (array.isNullAt(pos)) {
                return null;
            }
            return elementConverter.convert(array, pos);
        };
    }

    private static ArrayElementConverter createArrayElementConverter(LogicalType fieldType) {
        switch (fieldType.getTypeRoot()) {
            case NULL: {
                return (array, pos) -> null;
            }
            case BOOLEAN: {
                return ArrayData::getBoolean;
            }
            case TINYINT: {
                return ArrayData::getByte;
            }
            case SMALLINT: {
                return ArrayData::getShort;
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return ArrayData::getInt;
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return ArrayData::getLong;
            }
            case FLOAT: {
                return ArrayData::getFloat;
            }
            case DOUBLE: {
                return ArrayData::getDouble;
            }
            case CHAR: 
            case VARCHAR: {
                return (array, pos) -> array.getString(pos).toString();
            }
            case BINARY: 
            case VARBINARY: {
                return ArrayData::getBinary;
            }
            case DATE: {
                return (array, pos) -> RowToFieldDataUtils.convertDate(array.getLong(pos));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (array, pos) -> RowToFieldDataUtils.convertTime(array.getInt(pos));
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)fieldType).getPrecision();
                return (array, pos) -> RowToFieldDataUtils.convertTimestamp(array.getTimestamp(pos, timestampPrecision));
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int localZonedTimestampPrecision = ((LocalZonedTimestampType)fieldType).getPrecision();
                return (array, pos) -> RowToFieldDataUtils.convertTimestamp(array.getTimestamp(pos, localZonedTimestampPrecision));
            }
            case DECIMAL: {
                return RowToFieldDataUtils.createDecimalArrayElementConverter((DecimalType)fieldType);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + fieldType);
    }

    private static RowFieldConverter createDecimalRowFieldConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (row, pos) -> {
            DecimalData decimal = row.getDecimal(pos, precision, scale);
            return decimal.toBigDecimal();
        };
    }

    private static ArrayElementConverter createDecimalArrayElementConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return (array, pos) -> {
            DecimalData decimal = array.getDecimal(pos, precision, scale);
            return decimal.toBigDecimal();
        };
    }

    private static Date convertDate(long days) {
        LocalDate localDate = LocalDate.ofEpochDay(days);
        return Date.valueOf(localDate);
    }

    private static Time convertTime(int millisecond) {
        LocalTime time = LocalTime.ofNanoOfDay((long)millisecond * 1000000L);
        return Time.valueOf(time);
    }

    private static Timestamp convertTimestamp(TimestampData timestamp) {
        return timestamp.toTimestamp();
    }

    private static RowFieldConverter createArrayRowFieldConverter(ArrayType type) {
        LogicalType elementType = type.getElementType();
        ArrayElementConverter elementConverter = RowToFieldDataUtils.createNullableArrayElementConverter(elementType);
        return (row, pos) -> {
            ArrayData arrayData = row.getArray(pos);
            int numElements = arrayData.size();
            Object[] result = new Object[numElements];
            for (int i = 0; i < numElements; ++i) {
                result[i] = elementConverter.convert(arrayData, i);
            }
            return result;
        };
    }

    private static RowFieldConverter createRowRowFieldConverter(RowType type) {
        LogicalType[] fieldTypes = (LogicalType[])type.getFields().stream().map(RowType.RowField::getType).toArray(LogicalType[]::new);
        RowFieldConverter[] fieldConverters = (RowFieldConverter[])Arrays.stream(fieldTypes).map(RowDataToFieldConverters::createNullableRowFieldConverter).toArray(RowFieldConverter[]::new);
        int rowArity = type.getFieldCount();
        return (row, pos) -> {
            RowData value = row.getRow(pos, rowArity);
            Row result = new Row(rowArity);
            for (int i = 0; i < rowArity; ++i) {
                result.setField(i, fieldConverters[i].convert(value, i));
            }
            return result;
        };
    }

    private static interface ArrayElementConverter
    extends Serializable {
        public Object convert(ArrayData var1, int var2);
    }

    public static interface RowFieldConverter
    extends Serializable {
        public Object convert(RowData var1, int var2);
    }
}

