/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.io.Closeable;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.raft.Isolation;
import org.apache.kafka.raft.LogAppendInfo;
import org.apache.kafka.raft.LogFetchInfo;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.OffsetAndEpoch;

public interface ReplicatedLog
extends Closeable {
    public LogAppendInfo appendAsLeader(Records var1, int var2);

    public LogAppendInfo appendAsFollower(Records var1);

    public LogFetchInfo read(long var1, Isolation var3);

    public int lastFetchedEpoch();

    public Optional<OffsetAndEpoch> endOffsetForEpoch(int var1);

    public LogOffsetMetadata endOffset();

    public long startOffset();

    public void initializeLeaderEpoch(int var1);

    public void truncateTo(long var1);

    public void updateHighWatermark(LogOffsetMetadata var1);

    public TopicPartition topicPartition();

    default public OptionalLong truncateToEndOffset(OffsetAndEpoch endOffset) {
        long truncationOffset;
        int leaderEpoch = endOffset.epoch;
        if (leaderEpoch == 0) {
            truncationOffset = endOffset.offset;
        } else {
            Optional<OffsetAndEpoch> localEndOffsetOpt = this.endOffsetForEpoch(leaderEpoch);
            if (localEndOffsetOpt.isPresent()) {
                OffsetAndEpoch localEndOffset = localEndOffsetOpt.get();
                truncationOffset = localEndOffset.epoch == leaderEpoch ? Math.min(localEndOffset.offset, endOffset.offset) : Math.min(localEndOffset.offset, this.endOffset().offset);
            } else {
                truncationOffset = endOffset.offset;
            }
        }
        this.truncateTo(truncationOffset);
        return OptionalLong.of(truncationOffset);
    }

    @Override
    default public void close() {
    }
}

