/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.BitmapPositionDeleteIndex;
import org.apache.iceberg.deletes.DeleteCounter;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FilterIterator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Filter;
import org.apache.iceberg.util.SortedMerge;
import org.apache.iceberg.util.StructLikeSet;

public class Deletes {
    private static final Schema POSITION_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());

    private Deletes() {
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> rows, Function<T, StructLike> rowToDeleteKey, StructLikeSet deleteSet) {
        if (deleteSet.isEmpty()) {
            return rows;
        }
        EqualitySetDeleteFilter<T> equalityFilter = new EqualitySetDeleteFilter<T>(rowToDeleteKey, deleteSet);
        return equalityFilter.filter(rows);
    }

    public static <T> CloseableIterable<T> markDeleted(CloseableIterable<T> rows, Predicate<T> isDeleted, Consumer<T> deleteMarker) {
        return CloseableIterable.transform(rows, row -> {
            if (isDeleted.test(row)) {
                deleteMarker.accept(row);
            }
            return row;
        });
    }

    public static <T> CloseableIterable<T> filterDeleted(CloseableIterable<T> rows, final Predicate<T> isDeleted, final DeleteCounter counter) {
        Filter remainingRowsFilter = new Filter<T>(){

            @Override
            protected boolean shouldKeep(T item) {
                boolean deleted = isDeleted.test(item);
                if (deleted) {
                    counter.increment();
                }
                return !deleted;
            }
        };
        return remainingRowsFilter.filter(rows);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StructLikeSet toEqualitySet(CloseableIterable<StructLike> eqDeletes, Types.StructType eqType) {
        try (CloseableIterable<StructLike> deletes = eqDeletes;){
            StructLikeSet deleteSet = StructLikeSet.create(eqType);
            Iterables.addAll((Collection)deleteSet, deletes);
            StructLikeSet structLikeSet = deleteSet;
            return structLikeSet;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close equality delete source", e);
        }
    }

    public static <T extends StructLike> PositionDeleteIndex toPositionIndex(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform(locationFilter.filter(deletes), row -> (Long)POSITION_ACCESSOR.get(row)));
        return Deletes.toPositionIndex((CloseableIterable<Long>)CloseableIterable.concat((Iterable)positions));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PositionDeleteIndex toPositionIndex(CloseableIterable<Long> posDeletes) {
        try (CloseableIterable<Long> deletes = posDeletes;){
            BitmapPositionDeleteIndex positionDeleteIndex = new BitmapPositionDeleteIndex();
            deletes.forEach(positionDeleteIndex::delete);
            BitmapPositionDeleteIndex bitmapPositionDeleteIndex = positionDeleteIndex;
            return bitmapPositionDeleteIndex;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close position delete source", e);
        }
    }

    public static <T> CloseableIterable<T> streamingFilter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes) {
        return Deletes.streamingFilter(rows, rowToPosition, posDeletes, new DeleteCounter());
    }

    public static <T> CloseableIterable<T> streamingFilter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes, DeleteCounter counter) {
        return new PositionStreamDeleteFilter<T>(rows, rowToPosition, posDeletes, counter);
    }

    public static <T> CloseableIterable<T> streamingMarker(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes, Consumer<T> markDeleted) {
        return new PositionStreamDeleteMarker<T>(rows, rowToPosition, posDeletes, markDeleted);
    }

    public static CloseableIterable<Long> deletePositions(CharSequence dataLocation, CloseableIterable<StructLike> deleteFile) {
        return Deletes.deletePositions(dataLocation, ImmutableList.of(deleteFile));
    }

    public static <T extends StructLike> CloseableIterable<Long> deletePositions(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform(locationFilter.filter(deletes), row -> (Long)POSITION_ACCESSOR.get(row)));
        return new SortedMerge<Long>(Long::compare, positions);
    }

    private static class DataFileFilter<T extends StructLike>
    extends Filter<T> {
        private final CharSequence dataLocation;

        DataFileFilter(CharSequence dataLocation) {
            this.dataLocation = dataLocation;
        }

        @Override
        protected boolean shouldKeep(T posDelete) {
            return this.charSeqEquals(this.dataLocation, (CharSequence)FILENAME_ACCESSOR.get(posDelete));
        }

        private boolean charSeqEquals(CharSequence s1, CharSequence s2) {
            if (s1 == s2) {
                return true;
            }
            int count = s1.length();
            if (count != s2.length()) {
                return false;
            }
            if (s1 instanceof String && s2 instanceof String && s1.hashCode() != s2.hashCode()) {
                return false;
            }
            for (int i = count - 1; i >= 0; --i) {
                if (s1.charAt(i) == s2.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }

    private static class PositionStreamDeleteMarker<T>
    extends PositionStreamDeleteIterable<T> {
        private final Consumer<T> markDeleted;

        PositionStreamDeleteMarker(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> deletePositions, Consumer<T> markDeleted) {
            super(rows, rowToPosition, deletePositions);
            this.markDeleted = markDeleted;
        }

        @Override
        protected CloseableIterator<T> applyDelete(CloseableIterator<T> items) {
            return CloseableIterator.transform(items, row -> {
                if (this.isDeleted(row)) {
                    this.markDeleted.accept(row);
                }
                return row;
            });
        }
    }

    private static class PositionStreamDeleteFilter<T>
    extends PositionStreamDeleteIterable<T> {
        private final DeleteCounter counter;

        PositionStreamDeleteFilter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> deletePositions, DeleteCounter counter) {
            super(rows, rowToPosition, deletePositions);
            this.counter = counter;
        }

        @Override
        protected CloseableIterator<T> applyDelete(CloseableIterator<T> items) {
            return new FilterIterator<T>((Iterator)items){

                protected boolean shouldKeep(T item) {
                    boolean deleted = this.isDeleted(item);
                    if (deleted) {
                        counter.increment();
                    }
                    return !deleted;
                }
            };
        }
    }

    private static abstract class PositionStreamDeleteIterable<T>
    extends CloseableGroup
    implements CloseableIterable<T> {
        private final CloseableIterable<T> rows;
        private final CloseableIterator<Long> deletePosIterator;
        private final Function<T, Long> rowToPosition;
        private long nextDeletePos;

        PositionStreamDeleteIterable(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> deletePositions) {
            this.rows = rows;
            this.rowToPosition = rowToPosition;
            this.deletePosIterator = deletePositions.iterator();
        }

        public CloseableIterator<T> iterator() {
            CloseableIterator<T> iter;
            if (this.deletePosIterator.hasNext()) {
                this.nextDeletePos = (Long)this.deletePosIterator.next();
                iter = this.applyDelete(this.rows.iterator());
            } else {
                iter = this.rows.iterator();
            }
            this.addCloseable((Closeable)iter);
            this.addCloseable((Closeable)this.deletePosIterator);
            return iter;
        }

        boolean isDeleted(T row) {
            boolean isDeleted;
            long currentPos = this.rowToPosition.apply(row);
            if (currentPos < this.nextDeletePos) {
                return false;
            }
            boolean bl = isDeleted = currentPos == this.nextDeletePos;
            while (this.deletePosIterator.hasNext() && this.nextDeletePos <= currentPos) {
                this.nextDeletePos = (Long)this.deletePosIterator.next();
                if (isDeleted || currentPos != this.nextDeletePos) continue;
                isDeleted = true;
            }
            return isDeleted;
        }

        protected abstract CloseableIterator<T> applyDelete(CloseableIterator<T> var1);
    }

    private static class EqualitySetDeleteFilter<T>
    extends Filter<T> {
        private final StructLikeSet deletes;
        private final Function<T, StructLike> extractEqStruct;

        protected EqualitySetDeleteFilter(Function<T, StructLike> extractEq, StructLikeSet deletes) {
            this.extractEqStruct = extractEq;
            this.deletes = deletes;
        }

        @Override
        protected boolean shouldKeep(T row) {
            return !this.deletes.contains(this.extractEqStruct.apply(row));
        }
    }
}

