/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.converters.FileConverter;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.impl.InlongClientImpl;
import org.apache.inlong.manager.client.api.inner.client.InlongClusterClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantClient;
import org.apache.inlong.manager.client.api.inner.client.InlongTenantRoleClient;
import org.apache.inlong.manager.client.api.inner.client.UserClient;
import org.apache.inlong.manager.client.cli.AbstractCommand;
import org.apache.inlong.manager.client.cli.AbstractCommandRunner;
import org.apache.inlong.manager.client.cli.util.ClientUtils;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.cluster.ClusterNodeRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.ClusterTagRequest;
import org.apache.inlong.manager.pojo.sort.BaseSortConf;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.tenant.InlongTenantRequest;
import org.apache.inlong.manager.pojo.user.TenantRoleInfo;
import org.apache.inlong.manager.pojo.user.TenantRoleRequest;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.pojo.user.UserRequest;

@Parameters(commandDescription="Update resource by json file")
public class UpdateCommand
extends AbstractCommand {
    @Parameter
    private List<String> params;

    public UpdateCommand() {
        super("update");
        this.jcommander.addCommand("group", (Object)new UpdateGroup());
        this.jcommander.addCommand("cluster", (Object)new UpdateCluster());
        this.jcommander.addCommand("cluster-tag", (Object)new UpdateClusterTag());
        this.jcommander.addCommand("cluster-node", (Object)new UpdateClusterNode());
        this.jcommander.addCommand("user", (Object)new UpdateUser());
        this.jcommander.addCommand("tenant", (Object)new UpdateTenant());
        this.jcommander.addCommand("tenant-role", (Object)new UpdateTenantRole());
    }

    @Parameters(commandDescription="Update Tenant Role")
    private static class UpdateTenantRole
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-id", "--id"}, description="id to be modify")
        private Integer id;
        @Parameter(names={"-rc", "--role-code"}, description="new role code")
        private String roleCode;

        private UpdateTenantRole() {
        }

        @Override
        void run() {
            try {
                TenantRoleRequest request = new TenantRoleRequest();
                request.setId(this.id);
                ClientUtils.initClientFactory();
                InlongTenantRoleClient roleClient = ClientUtils.clientFactory.getInlongTenantRoleClient();
                TenantRoleInfo roleInfo = roleClient.get(this.id.intValue());
                if (roleInfo == null) {
                    throw new BusinessException(this.id + " not exist, please check.");
                }
                request.setUsername(roleInfo.getUsername());
                request.setDisabled(roleInfo.getDisabled());
                request.setVersion(roleInfo.getVersion());
                if (StringUtils.isNotEmpty((CharSequence)this.roleCode)) {
                    request.setRoleCode(this.roleCode);
                } else {
                    request.setRoleCode(roleInfo.getRoleCode());
                }
                request.setTenant(roleInfo.getTenant());
                if (roleClient.update(request)) {
                    System.out.println("Update user success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Update Tenant")
    private static class UpdateTenant
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-n", "--name"}, description="name to be modify")
        private String name;
        @Parameter(names={"-d", "--description"}, description="new description")
        private String description;

        private UpdateTenant() {
        }

        @Override
        void run() {
            try {
                InlongTenantRequest request = new InlongTenantRequest();
                request.setName(this.name);
                ClientUtils.initClientFactory();
                InlongTenantClient tenantClient = ClientUtils.clientFactory.getInlongTenantClient();
                InlongTenantInfo tenantInfo = tenantClient.getTenantByName(this.name);
                if (tenantInfo == null) {
                    throw new BusinessException(this.name + " not exist, please check.");
                }
                request.setId(tenantInfo.getId());
                request.setDescription(this.description);
                request.setVersion(tenantInfo.getVersion());
                if (tenantClient.update(request).booleanValue()) {
                    System.out.println("Update user success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Update User")
    private static class UpdateUser
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-u", "--username"}, description="username to be modify")
        private String username;
        @Parameter(names={"-p", "--password"}, description="new password")
        private String password;
        @Parameter(names={"-d", "--days"}, description="new valid days")
        private Integer validDays;

        private UpdateUser() {
        }

        @Override
        void run() {
            try {
                UserRequest request = new UserRequest();
                request.setName(this.username);
                ClientUtils.initClientFactory();
                UserClient userClient = ClientUtils.clientFactory.getUserClient();
                UserInfo userInfo = userClient.getByName(this.username);
                if (userInfo == null) {
                    throw new BusinessException(this.username + " not exist, please check.");
                }
                request.setId(userInfo.getId());
                request.setNewPassword(this.password);
                request.setAccountType(userInfo.getAccountType());
                request.setValidDays(this.validDays);
                request.setVersion(userInfo.getVersion());
                if (userClient.update(request) != null) {
                    System.out.println("Update user success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Update cluster node by json file")
    private static class UpdateClusterNode
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, description="json file", converter=FileConverter.class)
        private File file;

        private UpdateClusterNode() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                ClusterNodeRequest request = (ClusterNodeRequest)JsonUtils.parseObject((String)content, ClusterNodeRequest.class);
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                if (clusterClient.updateNode(request).booleanValue()) {
                    System.out.println("Update cluster node success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Update cluster tag by json file")
    private static class UpdateClusterTag
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, description="json file", converter=FileConverter.class)
        private File file;

        private UpdateClusterTag() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                ClusterTagRequest request = (ClusterTagRequest)JsonUtils.parseObject((String)content, ClusterTagRequest.class);
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                if (clusterClient.updateTag(request).booleanValue()) {
                    System.out.println("Update cluster tag success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Update cluster by json file")
    private static class UpdateCluster
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"-f", "--file"}, description="json file", converter=FileConverter.class)
        private File file;

        private UpdateCluster() {
        }

        @Override
        void run() {
            try {
                String content = ClientUtils.readFile(this.file);
                ClusterRequest request = (ClusterRequest)JsonUtils.parseObject((String)content, ClusterRequest.class);
                assert (request != null);
                ClientUtils.initClientFactory();
                InlongClusterClient clusterClient = ClientUtils.clientFactory.getClusterClient();
                if (clusterClient.update(request).booleanValue()) {
                    System.out.println("Update cluster success!");
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Parameters(commandDescription="Update group by json file")
    private static class UpdateGroup
    extends AbstractCommandRunner {
        @Parameter
        private List<String> params;
        @Parameter(names={"--group", "-g"}, required=true, description="inlong group id")
        private String inlongGroupId;
        @Parameter(names={"-c", "--config"}, required=true, description="json file")
        private File file;

        private UpdateGroup() {
        }

        @Override
        void run() {
            try {
                InlongClientImpl inlongClient = ClientUtils.getClient();
                InlongGroup group = inlongClient.getGroup(this.inlongGroupId);
                String fileContent = ClientUtils.readFile(this.file);
                if (StringUtils.isBlank((CharSequence)fileContent)) {
                    System.out.println("Update group failed: file was empty!");
                    return;
                }
                BaseSortConf sortConf = (BaseSortConf)JsonUtils.parseObject((String)fileContent, BaseSortConf.class);
                group.update(sortConf);
                System.out.println("Update group success!");
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

