/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.ValidationException;
import org.apache.inlong.sort.formats.base.TableFormatOptions;
import org.apache.inlong.sort.formats.base.TextFormatOptions;

public class TextFormatOptionsUtil {
    public static final String SQL = "SQL";
    public static final String ISO_8601 = "ISO-8601";
    public static final Set<String> TIMESTAMP_FORMAT_ENUM = new HashSet<String>(Arrays.asList("SQL", "ISO-8601"));
    public static final String MAP_NULL_KEY_MODE_FAIL = "FAIL";
    public static final String MAP_NULL_KEY_MODE_DROP = "DROP";
    public static final String MAP_NULL_KEY_MODE_LITERAL = "LITERAL";

    public static TextFormatOptions.TimestampFormat getTimestampFormat(String timestampFormat) {
        switch (timestampFormat) {
            case "SQL": {
                return TextFormatOptions.TimestampFormat.SQL;
            }
            case "ISO-8601": {
                return TextFormatOptions.TimestampFormat.ISO_8601;
            }
        }
        throw new TableException(String.format("Unsupported timestamp format '%s'. Validator should have checked that.", timestampFormat));
    }

    public static TextFormatOptions.MapNullKeyMode getMapNullKeyMode(String mapNullKeyMode) {
        switch (mapNullKeyMode.toUpperCase()) {
            case "FAIL": {
                return TextFormatOptions.MapNullKeyMode.FAIL;
            }
            case "DROP": {
                return TextFormatOptions.MapNullKeyMode.DROP;
            }
            case "LITERAL": {
                return TextFormatOptions.MapNullKeyMode.LITERAL;
            }
        }
        throw new TableException(String.format("Unsupported map null key handling mode '%s'. Validator should have checked that.", mapNullKeyMode));
    }

    public static void validateDecodingFormatOptions(ReadableConfig tableOptions) {
        boolean failOnMissingField = (Boolean)tableOptions.get(TextFormatOptions.FAIL_ON_MISSING_FIELD);
        boolean ignoreParseErrors = (Boolean)tableOptions.get(TableFormatOptions.IGNORE_ERRORS);
        if (ignoreParseErrors && failOnMissingField) {
            throw new ValidationException(String.format("%s and %s shouldn't both be true.", TextFormatOptions.FAIL_ON_MISSING_FIELD.key(), TableFormatOptions.IGNORE_ERRORS.key()));
        }
        TextFormatOptionsUtil.validateTimestampFormat(tableOptions);
        TextFormatOptionsUtil.validateCharset(tableOptions);
    }

    public static void validateEncodingFormatOptions(ReadableConfig tableOptions) {
        Set nullKeyModes = Arrays.stream(TextFormatOptions.MapNullKeyMode.values()).map(Objects::toString).collect(Collectors.toSet());
        if (!nullKeyModes.contains(((String)tableOptions.get(TextFormatOptions.MAP_NULL_KEY_MODE)).toUpperCase())) {
            throw new ValidationException(String.format("Unsupported value '%s' for option %s. Supported values are %s.", tableOptions.get(TextFormatOptions.MAP_NULL_KEY_MODE), TextFormatOptions.MAP_NULL_KEY_MODE.key(), nullKeyModes));
        }
        TextFormatOptionsUtil.validateTimestampFormat(tableOptions);
        TextFormatOptionsUtil.validateCharset(tableOptions);
    }

    static void validateTimestampFormat(ReadableConfig tableOptions) {
        String timestampFormat = (String)tableOptions.get(TextFormatOptions.TIMESTAMP_FORMAT);
        if (!TIMESTAMP_FORMAT_ENUM.contains(timestampFormat)) {
            throw new ValidationException(String.format("Unsupported value '%s' for %s. Supported values are [SQL, ISO-8601].", timestampFormat, TextFormatOptions.TIMESTAMP_FORMAT.key()));
        }
    }

    public static void validateCharset(ReadableConfig tableOptions) {
        String charset = (String)tableOptions.get(TextFormatOptions.CHARSET);
        try {
            Charset.forName(charset);
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Charset %s is not supported.", charset));
        }
    }

    private TextFormatOptionsUtil() {
    }
}

