/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.Function;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.StringConstantParam;
import org.apache.inlong.sort.protocol.transformation.TimeUnitConstantParam;

@JsonTypeName(value="intervalFunction")
public class IntervalFunction
implements Function {
    @Nonnull
    @JsonProperty(value="interval")
    private final StringConstantParam interval;
    @Nonnull
    @JsonProperty(value="timeUnit")
    private final TimeUnitConstantParam timeUnit;

    @JsonCreator
    public IntervalFunction(@Nonnull @JsonProperty(value="interval") StringConstantParam interval, @Nonnull @JsonProperty(value="timeUnit") TimeUnitConstantParam timeUnit) {
        this.interval = (StringConstantParam)Preconditions.checkNotNull((Object)interval, (Object)"interval is null");
        this.timeUnit = (TimeUnitConstantParam)Preconditions.checkNotNull((Object)timeUnit, (Object)"timeUnit is null");
    }

    @Override
    public List<FunctionParam> getParams() {
        return Arrays.asList(this.interval, this.timeUnit);
    }

    @Override
    public String getName() {
        return "INTERVAL";
    }

    @Override
    public String format() {
        return String.format("%s %s %s", this.getName(), this.interval.format(), this.timeUnit.format());
    }

    @Nonnull
    public StringConstantParam getInterval() {
        return this.interval;
    }

    @Nonnull
    public TimeUnitConstantParam getTimeUnit() {
        return this.timeUnit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntervalFunction)) {
            return false;
        }
        IntervalFunction other = (IntervalFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        StringConstantParam this$interval = this.getInterval();
        StringConstantParam other$interval = other.getInterval();
        if (this$interval == null ? other$interval != null : !((Object)this$interval).equals(other$interval)) {
            return false;
        }
        TimeUnitConstantParam this$timeUnit = this.getTimeUnit();
        TimeUnitConstantParam other$timeUnit = other.getTimeUnit();
        return !(this$timeUnit == null ? other$timeUnit != null : !((Object)this$timeUnit).equals(other$timeUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntervalFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringConstantParam $interval = this.getInterval();
        result = result * 59 + ($interval == null ? 43 : ((Object)$interval).hashCode());
        TimeUnitConstantParam $timeUnit = this.getTimeUnit();
        result = result * 59 + ($timeUnit == null ? 43 : ((Object)$timeUnit).hashCode());
        return result;
    }

    public String toString() {
        return "IntervalFunction(interval=" + this.getInterval() + ", timeUnit=" + this.getTimeUnit() + ")";
    }
}

