/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Map;
import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.common.api.EncryptionContext;

public class TopicMessageImpl<T>
implements Message<T> {
    private final String topicPartitionName;
    private final Message<T> msg;
    private final TopicMessageIdImpl messageId;
    final ConsumerImpl receivedByconsumer;

    TopicMessageImpl(String topicPartitionName, String topicName, Message<T> msg, ConsumerImpl receivedByConsumer) {
        this.topicPartitionName = topicPartitionName;
        this.receivedByconsumer = receivedByConsumer;
        this.msg = msg;
        this.messageId = new TopicMessageIdImpl(topicPartitionName, topicName, msg.getMessageId());
    }

    public String getTopicName() {
        return this.msg.getTopicName();
    }

    public String getTopicPartitionName() {
        return this.topicPartitionName;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public MessageId getInnerMessageId() {
        return this.messageId.getInnerMessageId();
    }

    public Map<String, String> getProperties() {
        return this.msg.getProperties();
    }

    public boolean hasProperty(String name) {
        return this.msg.hasProperty(name);
    }

    public String getProperty(String name) {
        return this.msg.getProperty(name);
    }

    public byte[] getData() {
        return this.msg.getData();
    }

    public int size() {
        return this.msg.size();
    }

    public long getPublishTime() {
        return this.msg.getPublishTime();
    }

    public long getEventTime() {
        return this.msg.getEventTime();
    }

    public long getSequenceId() {
        return this.msg.getSequenceId();
    }

    public String getProducerName() {
        return this.msg.getProducerName();
    }

    public boolean hasKey() {
        return this.msg.hasKey();
    }

    public String getKey() {
        return this.msg.getKey();
    }

    public boolean hasBase64EncodedKey() {
        return this.msg.hasBase64EncodedKey();
    }

    public byte[] getKeyBytes() {
        return this.msg.getKeyBytes();
    }

    public boolean hasOrderingKey() {
        return this.msg.hasOrderingKey();
    }

    public byte[] getOrderingKey() {
        return this.msg.getOrderingKey();
    }

    public T getValue() {
        return (T)this.msg.getValue();
    }

    public Optional<EncryptionContext> getEncryptionCtx() {
        return this.msg.getEncryptionCtx();
    }

    public int getRedeliveryCount() {
        return this.msg.getRedeliveryCount();
    }

    public byte[] getSchemaVersion() {
        return this.msg.getSchemaVersion();
    }

    public boolean isReplicated() {
        return this.msg.isReplicated();
    }

    public String getReplicatedFrom() {
        return this.msg.getReplicatedFrom();
    }

    public Message<T> getMessage() {
        return this.msg;
    }

    public Schema<T> getSchemaInternal() {
        if (this.msg instanceof MessageImpl) {
            MessageImpl message = (MessageImpl)this.msg;
            return message.getSchemaInternal();
        }
        return null;
    }

    public Optional<Schema<?>> getReaderSchema() {
        return this.msg.getReaderSchema();
    }

    public void release() {
        this.msg.release();
    }
}

