/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.InlongStream;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongStreamClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSinkClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSourceClient;
import org.apache.inlong.manager.client.api.inner.client.StreamTransformClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.client.api.util.StreamTransformTransfer;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNodeRelation;
import org.apache.inlong.manager.pojo.stream.StreamPipeline;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlongStreamImpl
implements InlongStream {
    private static final Logger log = LoggerFactory.getLogger(InlongStreamImpl.class);
    private InlongStreamClient streamClient;
    private StreamSourceClient sourceClient;
    private StreamSinkClient sinkClient;
    private StreamTransformClient transformClient;
    private String inlongGroupId;
    private String inlongStreamId;
    private Map<String, StreamSource> streamSources = Maps.newHashMap();
    private Map<String, StreamSink> streamSinks = Maps.newHashMap();
    private Map<String, StreamTransform> streamTransforms = Maps.newHashMap();
    private Set<String> sourcesToDelete = Sets.newHashSet();
    private Set<String> sinksToDelete = Sets.newHashSet();
    private Set<String> transformsToDelete = Sets.newHashSet();
    private List<StreamField> streamFields = Lists.newArrayList();

    public InlongStreamImpl(InlongStreamInfo streamInfo, ClientConfiguration configuration) {
        List sourceInfos;
        List sinkInfos;
        this.inlongGroupId = streamInfo.getInlongGroupId();
        this.inlongStreamId = streamInfo.getInlongStreamId();
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.streamClient = clientFactory.getStreamClient();
        this.sourceClient = clientFactory.getSourceClient();
        this.sinkClient = clientFactory.getSinkClient();
        this.transformClient = clientFactory.getTransformClient();
        List streamFields = streamInfo.getFieldList();
        if (CollectionUtils.isNotEmpty((Collection)streamFields)) {
            this.streamFields = streamFields.stream().map(fieldInfo -> new StreamField(fieldInfo.getId().intValue(), fieldInfo.getFieldType(), fieldInfo.getFieldName(), fieldInfo.getFieldComment(), fieldInfo.getFieldValue(), fieldInfo.getIsMetaField(), fieldInfo.getMetaFieldName(), fieldInfo.getOriginNodeName())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty((Collection)(sinkInfos = streamInfo.getSinkList()))) {
            this.streamSinks = sinkInfos.stream().collect(Collectors.toMap(StreamSink::getSinkName, streamSink -> streamSink, (sink1, sink2) -> {
                throw new RuntimeException(String.format("duplicate sinkName:%s in stream:%s", sink1.getSinkName(), this.inlongStreamId));
            }));
        }
        if (CollectionUtils.isNotEmpty((Collection)(sourceInfos = streamInfo.getSourceList()))) {
            this.streamSources = sourceInfos.stream().collect(Collectors.toMap(StreamSource::getSourceName, streamSource -> streamSource, (source1, source2) -> {
                throw new RuntimeException(String.format("duplicate sourceName: %s in streamId: %s", source1.getSourceName(), this.inlongStreamId));
            }));
        }
    }

    public InlongStreamImpl(String groupId, String streamId, ClientConfiguration configuration) {
        if (Optional.ofNullable(configuration).isPresent()) {
            ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
            this.streamClient = clientFactory.getStreamClient();
            this.sourceClient = clientFactory.getSourceClient();
            this.sinkClient = clientFactory.getSinkClient();
            this.transformClient = clientFactory.getTransformClient();
        }
        this.inlongGroupId = groupId;
        this.inlongStreamId = streamId;
    }

    @Override
    public List<StreamField> getStreamFields() {
        return this.streamFields;
    }

    @Override
    public Map<String, StreamSource> getSources() {
        return this.streamSources;
    }

    @Override
    public Map<String, StreamSink> getSinks() {
        return this.streamSinks;
    }

    @Override
    public Map<String, StreamTransform> getTransforms() {
        return this.streamTransforms;
    }

    @Override
    public InlongStream addSource(StreamSource source) {
        Preconditions.expectNotBlank((String)source.getSourceName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"source name cannot be null");
        String sourceName = source.getSourceName();
        if (this.streamSources.get(sourceName) != null) {
            throw new IllegalArgumentException(String.format("source name=%s has already be set", source));
        }
        this.streamSources.put(sourceName, source);
        return this;
    }

    @Override
    public InlongStream addSink(StreamSink streamSink) {
        Preconditions.expectNotBlank((String)streamSink.getSinkName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sink name cannot be null");
        String sinkName = streamSink.getSinkName();
        if (this.streamSinks.get(sinkName) != null) {
            throw new IllegalArgumentException(String.format("sink name=%s has already be set", streamSink));
        }
        this.streamSinks.put(sinkName, streamSink);
        return this;
    }

    @Override
    public InlongStream addTransform(StreamTransform transform) {
        Preconditions.expectNotBlank((String)transform.getTransformName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"transform name should not be empty");
        String transformName = transform.getTransformName();
        if (this.streamTransforms.get(transformName) != null) {
            throw new IllegalArgumentException(String.format("transform name=%s has already be set", transform));
        }
        this.streamTransforms.put(transformName, transform);
        return this;
    }

    @Override
    public InlongStream deleteSource(String sourceName) {
        this.sourcesToDelete.add(sourceName);
        return this;
    }

    @Override
    public InlongStream deleteSink(String sinkName) {
        this.sinksToDelete.add(sinkName);
        return this;
    }

    @Override
    public InlongStream deleteTransform(String transformName) {
        this.transformsToDelete.add(transformName);
        return this;
    }

    @Override
    public InlongStream updateSource(StreamSource source) {
        Preconditions.expectNotBlank((String)source.getSourceName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"source name cannot be null");
        this.streamSources.put(source.getSourceName(), source);
        return this;
    }

    @Override
    public InlongStream updateSink(StreamSink streamSink) {
        Preconditions.expectNotBlank((String)streamSink.getSinkName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sink name cannot be null");
        this.streamSinks.put(streamSink.getSinkName(), streamSink);
        return this;
    }

    @Override
    public InlongStream updateTransform(StreamTransform transform) {
        Preconditions.expectNotBlank((String)transform.getTransformName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"transform name cannot be null");
        this.streamTransforms.put(transform.getTransformName(), transform);
        return this;
    }

    @Override
    public StreamPipeline createPipeline() {
        StreamPipeline streamPipeline = new StreamPipeline();
        if (MapUtils.isEmpty(this.streamTransforms)) {
            StreamNodeRelation relation = new StreamNodeRelation();
            relation.setInputNodes(this.streamSources.keySet());
            relation.setOutputNodes(this.streamSinks.keySet());
            streamPipeline.setPipeline((List)Lists.newArrayList((Object[])new StreamNodeRelation[]{relation}));
            return streamPipeline;
        }
        HashMap relationMap = Maps.newHashMap();
        for (StreamTransform streamTransform : this.streamTransforms.values()) {
            String string = streamTransform.getTransformName();
            Set preNodes = streamTransform.getPreNodes();
            StreamNodeRelation relation = new StreamNodeRelation();
            relation.setInputNodes(preNodes);
            relation.setOutputNodes((Set)Sets.newHashSet((Object[])new String[]{string}));
            for (String preNode : preNodes) {
                StreamTransform transform = this.streamTransforms.get(preNode);
                if (transform == null) continue;
                transform.addPost(string);
            }
            relationMap.computeIfAbsent(preNodes, key -> Lists.newArrayList()).add(relation);
        }
        for (StreamTransform streamTransform : this.streamTransforms.values()) {
            String string = streamTransform.getTransformName();
            Set postNodes = streamTransform.getPostNodes();
            HashSet sinkSet = Sets.newHashSet();
            for (String postNode : postNodes) {
                StreamSink sink = this.streamSinks.get(postNode);
                if (sink == null) continue;
                sinkSet.add(sink.getSinkName());
            }
            if (!CollectionUtils.isNotEmpty((Collection)sinkSet)) continue;
            StreamNodeRelation relation = new StreamNodeRelation();
            HashSet preNodes = Sets.newHashSet((Object[])new String[]{string});
            relation.setInputNodes((Set)preNodes);
            relation.setOutputNodes((Set)sinkSet);
            relationMap.computeIfAbsent(preNodes, key -> Lists.newArrayList()).add(relation);
        }
        ArrayList relations = Lists.newArrayList();
        for (Map.Entry entry : relationMap.entrySet()) {
            List unmergedRelations = (List)entry.getValue();
            if (unmergedRelations.size() == 1) {
                relations.add(unmergedRelations.get(0));
                continue;
            }
            StreamNodeRelation mergedRelation = (StreamNodeRelation)unmergedRelations.get(0);
            for (int index = 1; index < unmergedRelations.size(); ++index) {
                StreamNodeRelation unmergedRelation = (StreamNodeRelation)unmergedRelations.get(index);
                unmergedRelation.getOutputNodes().forEach(arg_0 -> ((StreamNodeRelation)mergedRelation).addOutputNode(arg_0));
            }
            relations.add(mergedRelation);
        }
        streamPipeline.setPipeline((List)relations);
        Pair pair = streamPipeline.hasCircle();
        if (((Boolean)pair.getLeft()).booleanValue()) {
            Pair pair2 = (Pair)pair.getRight();
            throw new IllegalStateException(String.format("There is circle dependency in streamPipeline for node=%s and node=%s", pair2.getLeft(), pair2.getRight()));
        }
        return streamPipeline;
    }

    @Override
    public InlongStream update() {
        InlongStreamInfo streamInfo = this.streamClient.getStreamInfo(this.inlongGroupId, this.inlongStreamId);
        if (streamInfo == null) {
            throw new IllegalArgumentException(String.format("Stream not exists for group=%s and stream=%s", this.inlongGroupId, this.inlongStreamId));
        }
        streamInfo.setFieldList(this.streamFields);
        StreamPipeline streamPipeline = this.createPipeline();
        streamInfo.setExtParams(JsonUtils.toJsonString((Object)streamPipeline));
        Pair<Boolean, String> updateMsg = this.streamClient.updateStreamInfo(streamInfo);
        if (!((Boolean)updateMsg.getKey()).booleanValue()) {
            throw new RuntimeException(String.format("Update data stream failed: %s", updateMsg.getValue()));
        }
        this.initOrUpdateTransform(streamInfo);
        this.initOrUpdateSource(streamInfo);
        this.initOrUpdateSink(streamInfo);
        return this;
    }

    private void initOrUpdateTransform(InlongStreamInfo streamInfo) {
        List transformResponses = this.transformClient.listTransform(this.inlongGroupId, this.inlongStreamId).getList();
        ArrayList updateTransformNames = Lists.newArrayList();
        for (TransformResponse transformResponse : transformResponses) {
            TransformRequest transformRequest;
            StreamTransform transform = StreamTransformTransfer.parseStreamTransform(transformResponse);
            String transformName = transform.getTransformName();
            int id = transformResponse.getId();
            if (this.streamTransforms.get(transformName) != null) {
                StreamTransform newTransform = this.streamTransforms.get(transformName);
                TransformRequest transformRequest2 = StreamTransformTransfer.createTransformRequest(newTransform, streamInfo);
                transformRequest2.setId(Integer.valueOf(id));
                transformRequest2.setVersion(transformResponse.getVersion());
                Pair<Boolean, String> updateState = this.transformClient.updateTransform(transformRequest2);
                if (!((Boolean)updateState.getKey()).booleanValue()) {
                    throw new RuntimeException(String.format("Update transform=%s failed with err=%s", transformRequest2, updateState.getValue()));
                }
                updateTransformNames.add(transformName);
                continue;
            }
            if (!this.transformsToDelete.contains(transformName) || this.transformClient.deleteTransform(transformRequest = StreamTransformTransfer.createTransformRequest(transform, streamInfo))) continue;
            throw new RuntimeException(String.format("Delete transform=%s failed", transformRequest));
        }
        for (Map.Entry entry : this.streamTransforms.entrySet()) {
            String transformName = (String)entry.getKey();
            if (updateTransformNames.contains(transformName)) continue;
            StreamTransform transform = (StreamTransform)entry.getValue();
            TransformRequest transformRequest = StreamTransformTransfer.createTransformRequest(transform, streamInfo);
            this.transformClient.createTransform(transformRequest);
        }
    }

    private void initOrUpdateSource(InlongStreamInfo streamInfo) {
        String sourceName;
        List<StreamSource> streamSources = this.sourceClient.listSources(this.inlongGroupId, this.inlongStreamId);
        ArrayList updateSourceNames = Lists.newArrayList();
        for (StreamSource streamSource : streamSources) {
            sourceName = streamSource.getSourceName();
            int id = streamSource.getId();
            if (this.streamSources.get(sourceName) != null) {
                StreamSource streamSource2 = this.streamSources.get(sourceName);
                streamSource2.setId(Integer.valueOf(id));
                streamSource2.setInlongGroupId(streamInfo.getInlongGroupId());
                streamSource2.setInlongStreamId(streamInfo.getInlongStreamId());
                streamSource2.setVersion(streamSource.getVersion());
                Pair<Boolean, String> updateState = this.sourceClient.updateSource(streamSource2.genSourceRequest());
                if (!((Boolean)updateState.getKey()).booleanValue()) {
                    throw new RuntimeException(String.format("Update source=%s failed with err=%s", streamSource2, updateState.getValue()));
                }
                updateSourceNames.add(sourceName);
                continue;
            }
            if (!this.sourcesToDelete.contains(sourceName) || this.sourceClient.deleteSource(id)) continue;
            throw new RuntimeException(String.format("Delete source=%s failed", streamSource));
        }
        for (Map.Entry entry : this.streamSources.entrySet()) {
            sourceName = (String)entry.getKey();
            if (updateSourceNames.contains(sourceName)) continue;
            StreamSource streamSource = (StreamSource)entry.getValue();
            streamSource.setInlongGroupId(streamInfo.getInlongGroupId());
            streamSource.setInlongStreamId(streamInfo.getInlongStreamId());
            this.sourceClient.createSource(streamSource.genSourceRequest());
        }
    }

    private void initOrUpdateSink(InlongStreamInfo streamInfo) {
        String sinkName;
        List<StreamSink> streamSinks = this.sinkClient.listSinks(this.inlongGroupId, this.inlongStreamId);
        ArrayList updateSinkNames = Lists.newArrayList();
        for (StreamSink streamSink : streamSinks) {
            sinkName = streamSink.getSinkName();
            int id = streamSink.getId();
            if (this.streamSinks.get(sinkName) != null) {
                StreamSink streamSink2 = this.streamSinks.get(sinkName);
                streamSink2.setId(Integer.valueOf(id));
                streamSink2.setInlongGroupId(streamInfo.getInlongGroupId());
                streamSink2.setInlongStreamId(streamInfo.getInlongStreamId());
                streamSink2.setVersion(streamSink.getVersion());
                Pair<Boolean, String> updateState = this.sinkClient.updateSink(streamSink2.genSinkRequest());
                if (!((Boolean)updateState.getKey()).booleanValue()) {
                    throw new RuntimeException(String.format("Update sink=%s failed with err=%s", streamSink2, updateState.getValue()));
                }
                updateSinkNames.add(sinkName);
                continue;
            }
            if (!this.sinksToDelete.contains(sinkName) || this.sinkClient.deleteSink(id)) continue;
            throw new RuntimeException(String.format("Delete sink=%s failed", streamSink));
        }
        for (Map.Entry entry : this.streamSinks.entrySet()) {
            sinkName = (String)entry.getKey();
            if (updateSinkNames.contains(sinkName)) continue;
            StreamSink streamSink = (StreamSink)entry.getValue();
            streamSink.setInlongGroupId(streamInfo.getInlongGroupId());
            streamSink.setInlongStreamId(streamInfo.getInlongStreamId());
            this.sinkClient.createSink(streamSink.genSinkRequest());
        }
    }

    @Override
    public StreamSink getSinkInfoById(Integer sinkId) {
        Preconditions.expectNotNull((Object)sinkId, (String)"sinkId cannot be null");
        return this.streamSinks.values().stream().filter(streamSink -> streamSink.getId().equals(sinkId)).findAny().orElseGet(() -> this.sinkClient.getSinkInfo(sinkId));
    }

    @Override
    public StreamSink getSinkInfoByName(String sinkName) {
        Preconditions.expectNotBlank((String)sinkName, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"sinkName cannot be empty");
        return this.streamSinks.get(sinkName);
    }

    @Override
    public StreamSource getSourceById(int sourceId) {
        Preconditions.expectNotNull((Object)sourceId, (String)"sinkId cannot be null");
        return this.streamSources.values().stream().filter(streamSource -> streamSource.getId().equals(sourceId)).findAny().orElseGet(() -> this.sourceClient.get(sourceId));
    }

    public InlongStreamClient getStreamClient() {
        return this.streamClient;
    }

    public StreamSourceClient getSourceClient() {
        return this.sourceClient;
    }

    public StreamSinkClient getSinkClient() {
        return this.sinkClient;
    }

    public StreamTransformClient getTransformClient() {
        return this.transformClient;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    @Override
    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public Map<String, StreamSource> getStreamSources() {
        return this.streamSources;
    }

    public Map<String, StreamSink> getStreamSinks() {
        return this.streamSinks;
    }

    public Map<String, StreamTransform> getStreamTransforms() {
        return this.streamTransforms;
    }

    public Set<String> getSourcesToDelete() {
        return this.sourcesToDelete;
    }

    public Set<String> getSinksToDelete() {
        return this.sinksToDelete;
    }

    public Set<String> getTransformsToDelete() {
        return this.transformsToDelete;
    }

    public void setStreamClient(InlongStreamClient streamClient) {
        this.streamClient = streamClient;
    }

    public void setSourceClient(StreamSourceClient sourceClient) {
        this.sourceClient = sourceClient;
    }

    public void setSinkClient(StreamSinkClient sinkClient) {
        this.sinkClient = sinkClient;
    }

    public void setTransformClient(StreamTransformClient transformClient) {
        this.transformClient = transformClient;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setStreamSources(Map<String, StreamSource> streamSources) {
        this.streamSources = streamSources;
    }

    public void setStreamSinks(Map<String, StreamSink> streamSinks) {
        this.streamSinks = streamSinks;
    }

    public void setStreamTransforms(Map<String, StreamTransform> streamTransforms) {
        this.streamTransforms = streamTransforms;
    }

    public void setSourcesToDelete(Set<String> sourcesToDelete) {
        this.sourcesToDelete = sourcesToDelete;
    }

    public void setSinksToDelete(Set<String> sinksToDelete) {
        this.sinksToDelete = sinksToDelete;
    }

    public void setTransformsToDelete(Set<String> transformsToDelete) {
        this.transformsToDelete = transformsToDelete;
    }

    public void setStreamFields(List<StreamField> streamFields) {
        this.streamFields = streamFields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongStreamImpl)) {
            return false;
        }
        InlongStreamImpl other = (InlongStreamImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InlongStreamClient this$streamClient = this.getStreamClient();
        InlongStreamClient other$streamClient = other.getStreamClient();
        if (this$streamClient == null ? other$streamClient != null : !this$streamClient.equals(other$streamClient)) {
            return false;
        }
        StreamSourceClient this$sourceClient = this.getSourceClient();
        StreamSourceClient other$sourceClient = other.getSourceClient();
        if (this$sourceClient == null ? other$sourceClient != null : !this$sourceClient.equals(other$sourceClient)) {
            return false;
        }
        StreamSinkClient this$sinkClient = this.getSinkClient();
        StreamSinkClient other$sinkClient = other.getSinkClient();
        if (this$sinkClient == null ? other$sinkClient != null : !this$sinkClient.equals(other$sinkClient)) {
            return false;
        }
        StreamTransformClient this$transformClient = this.getTransformClient();
        StreamTransformClient other$transformClient = other.getTransformClient();
        if (this$transformClient == null ? other$transformClient != null : !this$transformClient.equals(other$transformClient)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        Map<String, StreamSource> this$streamSources = this.getStreamSources();
        Map<String, StreamSource> other$streamSources = other.getStreamSources();
        if (this$streamSources == null ? other$streamSources != null : !((Object)this$streamSources).equals(other$streamSources)) {
            return false;
        }
        Map<String, StreamSink> this$streamSinks = this.getStreamSinks();
        Map<String, StreamSink> other$streamSinks = other.getStreamSinks();
        if (this$streamSinks == null ? other$streamSinks != null : !((Object)this$streamSinks).equals(other$streamSinks)) {
            return false;
        }
        Map<String, StreamTransform> this$streamTransforms = this.getStreamTransforms();
        Map<String, StreamTransform> other$streamTransforms = other.getStreamTransforms();
        if (this$streamTransforms == null ? other$streamTransforms != null : !((Object)this$streamTransforms).equals(other$streamTransforms)) {
            return false;
        }
        Set<String> this$sourcesToDelete = this.getSourcesToDelete();
        Set<String> other$sourcesToDelete = other.getSourcesToDelete();
        if (this$sourcesToDelete == null ? other$sourcesToDelete != null : !((Object)this$sourcesToDelete).equals(other$sourcesToDelete)) {
            return false;
        }
        Set<String> this$sinksToDelete = this.getSinksToDelete();
        Set<String> other$sinksToDelete = other.getSinksToDelete();
        if (this$sinksToDelete == null ? other$sinksToDelete != null : !((Object)this$sinksToDelete).equals(other$sinksToDelete)) {
            return false;
        }
        Set<String> this$transformsToDelete = this.getTransformsToDelete();
        Set<String> other$transformsToDelete = other.getTransformsToDelete();
        if (this$transformsToDelete == null ? other$transformsToDelete != null : !((Object)this$transformsToDelete).equals(other$transformsToDelete)) {
            return false;
        }
        List<StreamField> this$streamFields = this.getStreamFields();
        List<StreamField> other$streamFields = other.getStreamFields();
        return !(this$streamFields == null ? other$streamFields != null : !((Object)this$streamFields).equals(other$streamFields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlongStreamImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InlongStreamClient $streamClient = this.getStreamClient();
        result = result * 59 + ($streamClient == null ? 43 : $streamClient.hashCode());
        StreamSourceClient $sourceClient = this.getSourceClient();
        result = result * 59 + ($sourceClient == null ? 43 : $sourceClient.hashCode());
        StreamSinkClient $sinkClient = this.getSinkClient();
        result = result * 59 + ($sinkClient == null ? 43 : $sinkClient.hashCode());
        StreamTransformClient $transformClient = this.getTransformClient();
        result = result * 59 + ($transformClient == null ? 43 : $transformClient.hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        Map<String, StreamSource> $streamSources = this.getStreamSources();
        result = result * 59 + ($streamSources == null ? 43 : ((Object)$streamSources).hashCode());
        Map<String, StreamSink> $streamSinks = this.getStreamSinks();
        result = result * 59 + ($streamSinks == null ? 43 : ((Object)$streamSinks).hashCode());
        Map<String, StreamTransform> $streamTransforms = this.getStreamTransforms();
        result = result * 59 + ($streamTransforms == null ? 43 : ((Object)$streamTransforms).hashCode());
        Set<String> $sourcesToDelete = this.getSourcesToDelete();
        result = result * 59 + ($sourcesToDelete == null ? 43 : ((Object)$sourcesToDelete).hashCode());
        Set<String> $sinksToDelete = this.getSinksToDelete();
        result = result * 59 + ($sinksToDelete == null ? 43 : ((Object)$sinksToDelete).hashCode());
        Set<String> $transformsToDelete = this.getTransformsToDelete();
        result = result * 59 + ($transformsToDelete == null ? 43 : ((Object)$transformsToDelete).hashCode());
        List<StreamField> $streamFields = this.getStreamFields();
        result = result * 59 + ($streamFields == null ? 43 : ((Object)$streamFields).hashCode());
        return result;
    }

    public String toString() {
        return "InlongStreamImpl(streamClient=" + this.getStreamClient() + ", sourceClient=" + this.getSourceClient() + ", sinkClient=" + this.getSinkClient() + ", transformClient=" + this.getTransformClient() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", streamSources=" + this.getStreamSources() + ", streamSinks=" + this.getStreamSinks() + ", streamTransforms=" + this.getStreamTransforms() + ", sourcesToDelete=" + this.getSourcesToDelete() + ", sinksToDelete=" + this.getSinksToDelete() + ", transformsToDelete=" + this.getTransformsToDelete() + ", streamFields=" + this.getStreamFields() + ")";
    }
}

