/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.net;

import com.moilioncircle.redis.replicator.Configuration;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class RedisSocketFactory
extends SocketFactory {
    protected final Configuration configuration;

    public RedisSocketFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (this.configuration.isSsl()) {
            return this.buildSsl(this.build(this.buildSslSocketFactory().createSocket(host, port)), host);
        }
        return this.build(new Socket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.configuration.isSsl()) {
            return this.buildSsl(this.build(this.buildSslSocketFactory().createSocket(host, port, localAddr, localPort)), host);
        }
        return this.build(new Socket(host, port, localAddr, localPort));
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        if (this.configuration.isSsl()) {
            return this.buildSsl(this.build(this.buildSslSocketFactory().createSocket(address, port)), address.getHostAddress());
        }
        return this.build(new Socket(address, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddr, int localPort) throws IOException {
        if (this.configuration.isSsl()) {
            return this.buildSsl(this.build(this.buildSslSocketFactory().createSocket(address, port, localAddr, localPort)), address.getHostAddress());
        }
        return this.build(new Socket(address, port, localAddr, localPort));
    }

    public Socket createSocket(String host, int port, int timeout) throws IOException {
        Socket socket = new Socket();
        this.build(socket);
        socket.connect(new InetSocketAddress(host, port), timeout);
        if (this.configuration.isSsl()) {
            socket = this.buildSslSocketFactory().createSocket(socket, host, port, true);
            return this.buildSsl(socket, host);
        }
        return socket;
    }

    private Socket build(Socket socket) throws SocketException {
        socket.setReuseAddress(true);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        socket.setSoLinger(true, 0);
        if (this.configuration.getReadTimeout() > 0) {
            socket.setSoTimeout(this.configuration.getReadTimeout());
        }
        if (this.configuration.getReceiveBufferSize() > 0) {
            socket.setReceiveBufferSize(this.configuration.getReceiveBufferSize());
        }
        if (this.configuration.getSendBufferSize() > 0) {
            socket.setSendBufferSize(this.configuration.getSendBufferSize());
        }
        return socket;
    }

    private Socket buildSsl(Socket socket, String host) throws SocketException {
        if (this.configuration.getSslParameters() != null) {
            ((SSLSocket)socket).setSSLParameters(this.configuration.getSslParameters());
        }
        if (this.configuration.getHostnameVerifier() != null && !this.configuration.getHostnameVerifier().verify(host, ((SSLSocket)socket).getSession())) {
            throw new SocketException("the connection to " + host + " failed ssl/tls hostname verification.");
        }
        return socket;
    }

    private SSLSocketFactory buildSslSocketFactory() {
        SSLSocketFactory factory = this.configuration.getSslContextFactory() != null ? this.configuration.getSslContextFactory().create().getSocketFactory() : this.configuration.getSslSocketFactory();
        return factory;
    }
}

