/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.dolphinscheduler;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.schedule.ScheduleEngine;
import org.apache.inlong.manager.schedule.dolphinscheduler.DolphinScheduleOperator;
import org.apache.inlong.manager.schedule.dolphinscheduler.DolphinScheduleUtils;
import org.apache.inlong.manager.schedule.exception.DolphinScheduleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DolphinScheduleEngine
implements ScheduleEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DolphinScheduleEngine.class);
    @Value(value="${schedule.engine.inlong.manager.url:http://127.0.0.1:8083}")
    private String inlongManagerUrl;
    @Value(value="${default.admin.user:admin}")
    private String username;
    @Value(value="${default.admin.password:inlong}")
    private String password;
    @Value(value="${schedule.engine.dolphinscheduler.url:http://127.0.0.1:12345/dolphinscheduler}")
    private String dolphinUrl;
    @Value(value="${schedule.engine.dolphinscheduler.token:default_token_value}")
    private String token;
    @Resource
    private DolphinScheduleOperator dolphinScheduleOperator;
    private long projectCode;
    private String projectBaseUrl;
    private final Map<Long, String> scheduledProcessMap;

    @PostConstruct
    public void init() {
        this.projectBaseUrl = this.dolphinUrl + "/projects";
    }

    public DolphinScheduleEngine(String inlongManagerUrl, String username, String password, String dolphinUrl, String token) {
        this.inlongManagerUrl = inlongManagerUrl;
        this.username = username;
        this.password = password;
        this.dolphinUrl = dolphinUrl;
        this.token = token;
        this.scheduledProcessMap = new ConcurrentHashMap<Long, String>();
    }

    public DolphinScheduleEngine() {
        this.scheduledProcessMap = new ConcurrentHashMap<Long, String>();
    }

    @Override
    public void start() {
        LOGGER.info("Starting dolphin scheduler engine, Checking project exists...");
        long code = this.dolphinScheduleOperator.checkAndGetUniqueId(this.projectBaseUrl, this.token, "default_inlong_offline_scheduler");
        if (code != 0L) {
            LOGGER.info("Project exists, project code: {}", (Object)code);
            this.projectCode = code;
            LOGGER.info("Starting synchronize existing process definition");
            String queryProcessDefUrl = this.projectBaseUrl + "/" + this.projectCode + "/process-definition" + "/query-process-definition-list";
            this.scheduledProcessMap.putAll(this.dolphinScheduleOperator.queryAllProcessDef(queryProcessDefUrl, this.token));
        } else {
            LOGGER.info("There is no inlong offline project exists, default project will be created");
            this.projectCode = this.dolphinScheduleOperator.creatProject(this.projectBaseUrl, this.token, "default_inlong_offline_scheduler", "default scheduler project for inlong offline job");
        }
    }

    @Override
    @VisibleForTesting
    public boolean handleRegister(ScheduleInfo scheduleInfo) {
        this.start();
        String processDefUrl = this.projectBaseUrl + "/" + this.projectCode + "/process-definition";
        String scheduleUrl = this.projectBaseUrl + "/" + this.projectCode + "/schedules";
        String processName = scheduleInfo.getInlongGroupId() + "_inlong_offline_process_definition";
        String processDesc = "scheduler process definition for inlong group: " + scheduleInfo.getInlongGroupId();
        LOGGER.info("Dolphin Scheduler handle register begin for {}, Checking process definition id uniqueness...", (Object)scheduleInfo.getInlongGroupId());
        try {
            long processDefCode = this.dolphinScheduleOperator.checkAndGetUniqueId(processDefUrl, this.token, processName);
            boolean online = false;
            if (processDefCode != 0L || this.scheduledProcessMap.containsKey(processDefCode)) {
                LOGGER.info("Process definition exists, process definition id: {}, deleting...", (Object)processDefCode);
                if (this.dolphinScheduleOperator.releaseProcessDef(processDefUrl, processDefCode, this.token, "OFFLINE")) {
                    this.dolphinScheduleOperator.deleteProcessDef(processDefUrl, this.token, processDefCode);
                    this.scheduledProcessMap.remove(processDefCode);
                }
            }
            String taskCodeUrl = this.projectBaseUrl + "/" + this.projectCode + "/task-definition/gen-task-codes";
            long taskCode = this.dolphinScheduleOperator.genTaskCode(taskCodeUrl, this.token);
            LOGGER.info("Generate task code for process definition success, task code: {}", (Object)taskCode);
            long offset = DolphinScheduleUtils.calculateOffset(scheduleInfo);
            processDefCode = this.dolphinScheduleOperator.createProcessDef(processDefUrl, this.token, processName, processDesc, taskCode, this.inlongManagerUrl, this.username, this.password, offset, scheduleInfo.getInlongGroupId());
            LOGGER.info("Create process definition success, process definition code: {}", (Object)processDefCode);
            if (this.dolphinScheduleOperator.releaseProcessDef(processDefUrl, processDefCode, this.token, "ONLINE")) {
                LOGGER.info("Release process definition success, release status: {}", (Object)"ONLINE");
                int scheduleId = this.dolphinScheduleOperator.createScheduleForProcessDef(scheduleUrl, processDefCode, this.token, scheduleInfo);
                LOGGER.info("Create schedule for process definition success, schedule info: {}", (Object)scheduleInfo);
                online = this.dolphinScheduleOperator.onlineScheduleForProcessDef(scheduleUrl, scheduleId, this.token);
                LOGGER.info("Online schedule for process definition, status: {}", (Object)online);
            }
            this.scheduledProcessMap.putIfAbsent(processDefCode, processName);
            return online;
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle unregister dolphin scheduler: ", (Throwable)e);
            throw new DolphinScheduleException(String.format("Failed to handle unregister dolphin scheduler: %s", e.getMessage()));
        }
    }

    @Override
    @VisibleForTesting
    public boolean handleUnregister(String groupId) {
        this.start();
        String processName = groupId + "_inlong_offline_process_definition";
        String processDefUrl = this.projectBaseUrl + "/" + this.projectCode + "/process-definition";
        LOGGER.info("Dolphin Scheduler handle Unregister begin for {}, Checking process definition id uniqueness...", (Object)groupId);
        try {
            long processDefCode = this.dolphinScheduleOperator.checkAndGetUniqueId(processDefUrl, this.token, processName);
            if (processDefCode != 0L || this.scheduledProcessMap.containsKey(processDefCode)) {
                LOGGER.info("Deleting process definition, process definition id: {}", (Object)processDefCode);
                if (this.dolphinScheduleOperator.releaseProcessDef(processDefUrl, processDefCode, this.token, "OFFLINE")) {
                    this.dolphinScheduleOperator.deleteProcessDef(processDefUrl, this.token, processDefCode);
                    this.scheduledProcessMap.remove(processDefCode);
                    LOGGER.info("Process definition deleted");
                }
            }
            LOGGER.info("Un-registered dolphin schedule info for {}", (Object)groupId);
            return !this.scheduledProcessMap.containsKey(processDefCode);
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle unregister dolphin scheduler: ", (Throwable)e);
            throw new DolphinScheduleException(String.format("Failed to handle unregister dolphin scheduler: %s", e.getMessage()));
        }
    }

    @Override
    @VisibleForTesting
    public boolean handleUpdate(ScheduleInfo scheduleInfo) {
        LOGGER.info("Update dolphin schedule info for {}", (Object)scheduleInfo.getInlongGroupId());
        try {
            return this.handleUnregister(scheduleInfo.getInlongGroupId()) && this.handleRegister(scheduleInfo);
        }
        catch (Exception e) {
            LOGGER.error("Failed to handle update dolphin scheduler: ", (Throwable)e);
            throw new DolphinScheduleException(String.format("Failed to handle update dolphin scheduler: %s", e.getMessage()));
        }
    }

    @Override
    public void stop() {
        LOGGER.info("Stopping dolphin scheduler engine...");
        String processDefUrl = this.projectBaseUrl + "/" + this.projectCode + "/process-definition";
        try {
            String queryProcessDefUrl = this.projectBaseUrl + "/" + this.projectCode + "/process-definition" + "/query-process-definition-list";
            Map<Long, String> allProcessDef = this.dolphinScheduleOperator.queryAllProcessDef(queryProcessDefUrl, this.token);
            for (Long processDefCode : allProcessDef.keySet()) {
                LOGGER.info("delete process definition id: {}", (Object)processDefCode);
                this.dolphinScheduleOperator.releaseProcessDef(processDefUrl, processDefCode, this.token, "OFFLINE");
                this.dolphinScheduleOperator.deleteProcessDef(processDefUrl, this.token, processDefCode);
                this.scheduledProcessMap.remove(processDefCode);
            }
            this.dolphinScheduleOperator.deleteProject(this.projectBaseUrl, this.token, this.projectCode);
            LOGGER.info("Dolphin scheduler engine stopped");
        }
        catch (Exception e) {
            LOGGER.error("Failed to stop dolphin scheduler: ", (Throwable)e);
            throw new DolphinScheduleException(String.format("Failed to stop dolphin scheduler: %s", e.getMessage()));
        }
    }

    public String getInlongManagerUrl() {
        return this.inlongManagerUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDolphinUrl() {
        return this.dolphinUrl;
    }

    public String getToken() {
        return this.token;
    }

    public DolphinScheduleOperator getDolphinScheduleOperator() {
        return this.dolphinScheduleOperator;
    }

    public long getProjectCode() {
        return this.projectCode;
    }

    public String getProjectBaseUrl() {
        return this.projectBaseUrl;
    }

    public Map<Long, String> getScheduledProcessMap() {
        return this.scheduledProcessMap;
    }

    public void setInlongManagerUrl(String inlongManagerUrl) {
        this.inlongManagerUrl = inlongManagerUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDolphinUrl(String dolphinUrl) {
        this.dolphinUrl = dolphinUrl;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDolphinScheduleOperator(DolphinScheduleOperator dolphinScheduleOperator) {
        this.dolphinScheduleOperator = dolphinScheduleOperator;
    }

    public void setProjectCode(long projectCode) {
        this.projectCode = projectCode;
    }

    public void setProjectBaseUrl(String projectBaseUrl) {
        this.projectBaseUrl = projectBaseUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DolphinScheduleEngine)) {
            return false;
        }
        DolphinScheduleEngine other = (DolphinScheduleEngine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getProjectCode() != other.getProjectCode()) {
            return false;
        }
        String this$inlongManagerUrl = this.getInlongManagerUrl();
        String other$inlongManagerUrl = other.getInlongManagerUrl();
        if (this$inlongManagerUrl == null ? other$inlongManagerUrl != null : !this$inlongManagerUrl.equals(other$inlongManagerUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dolphinUrl = this.getDolphinUrl();
        String other$dolphinUrl = other.getDolphinUrl();
        if (this$dolphinUrl == null ? other$dolphinUrl != null : !this$dolphinUrl.equals(other$dolphinUrl)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        DolphinScheduleOperator this$dolphinScheduleOperator = this.getDolphinScheduleOperator();
        DolphinScheduleOperator other$dolphinScheduleOperator = other.getDolphinScheduleOperator();
        if (this$dolphinScheduleOperator == null ? other$dolphinScheduleOperator != null : !this$dolphinScheduleOperator.equals(other$dolphinScheduleOperator)) {
            return false;
        }
        String this$projectBaseUrl = this.getProjectBaseUrl();
        String other$projectBaseUrl = other.getProjectBaseUrl();
        if (this$projectBaseUrl == null ? other$projectBaseUrl != null : !this$projectBaseUrl.equals(other$projectBaseUrl)) {
            return false;
        }
        Map<Long, String> this$scheduledProcessMap = this.getScheduledProcessMap();
        Map<Long, String> other$scheduledProcessMap = other.getScheduledProcessMap();
        return !(this$scheduledProcessMap == null ? other$scheduledProcessMap != null : !((Object)this$scheduledProcessMap).equals(other$scheduledProcessMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DolphinScheduleEngine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $projectCode = this.getProjectCode();
        result = result * 59 + (int)($projectCode >>> 32 ^ $projectCode);
        String $inlongManagerUrl = this.getInlongManagerUrl();
        result = result * 59 + ($inlongManagerUrl == null ? 43 : $inlongManagerUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dolphinUrl = this.getDolphinUrl();
        result = result * 59 + ($dolphinUrl == null ? 43 : $dolphinUrl.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        DolphinScheduleOperator $dolphinScheduleOperator = this.getDolphinScheduleOperator();
        result = result * 59 + ($dolphinScheduleOperator == null ? 43 : $dolphinScheduleOperator.hashCode());
        String $projectBaseUrl = this.getProjectBaseUrl();
        result = result * 59 + ($projectBaseUrl == null ? 43 : $projectBaseUrl.hashCode());
        Map<Long, String> $scheduledProcessMap = this.getScheduledProcessMap();
        result = result * 59 + ($scheduledProcessMap == null ? 43 : ((Object)$scheduledProcessMap).hashCode());
        return result;
    }

    public String toString() {
        return "DolphinScheduleEngine(inlongManagerUrl=" + this.getInlongManagerUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dolphinUrl=" + this.getDolphinUrl() + ", token=" + this.getToken() + ", dolphinScheduleOperator=" + this.getDolphinScheduleOperator() + ", projectCode=" + this.getProjectCode() + ", projectBaseUrl=" + this.getProjectBaseUrl() + ", scheduledProcessMap=" + this.getScheduledProcessMap() + ")";
    }
}

