/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.dolphinscheduler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.bounded.BoundaryType;
import org.apache.inlong.manager.pojo.schedule.ScheduleInfo;
import org.apache.inlong.manager.pojo.schedule.dolphinschedule.DSTaskDefinition;
import org.apache.inlong.manager.pojo.schedule.dolphinschedule.DSTaskParams;
import org.apache.inlong.manager.pojo.schedule.dolphinschedule.DSTaskRelation;
import org.apache.inlong.manager.pojo.schedule.dolphinschedule.DScheduleInfo;
import org.apache.inlong.manager.schedule.ScheduleUnit;
import org.apache.inlong.manager.schedule.dolphinscheduler.DolphinScheduleEngine;
import org.apache.inlong.manager.schedule.exception.DolphinScheduleException;
import org.apache.logging.log4j.core.util.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DolphinScheduleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DolphinScheduleEngine.class);
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String DELETE = "DELETE";
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;
    private static final long MILLIS_IN_WEEK = 604800000L;
    private static final long MILLIS_IN_MONTH = 2592000000L;
    private static final long MILLIS_IN_YEAR = 31536000000L;
    private static final String CONTENT_TYPE = "Content-Type: application/json; charset=utf-8";
    private static final String SHELL_REQUEST_API = "/inlong/manager/api/group/submitOfflineJob";
    private static final OkHttpClient CLIENT = new OkHttpClient();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private DolphinScheduleUtils() {
    }

    public static long checkAndGetUniqueId(String url, String token, String searchVal) {
        try {
            JsonObject project;
            String name;
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            Map<String, String> queryParams = DolphinScheduleUtils.buildPageParam(searchVal);
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, GET, queryParams, header);
            JsonObject data = response.get("data").getAsJsonObject();
            JsonArray totalList = data.getAsJsonArray("totalList");
            if (totalList != null && totalList.size() == 1 && (name = (project = totalList.get(0).getAsJsonObject()).get("name").getAsString()).equals(searchVal)) {
                return project.get("code").getAsLong();
            }
            return 0L;
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during checkAndGetUniqueId", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error parsing json during unique ID check for: %s at URL: %s", searchVal, url), e);
        }
        catch (DolphinScheduleException e) {
            LOGGER.error("DolphinScheduleException during unique ID check: {}", (Object)e.getDetailedMessage(), (Object)e);
            throw new DolphinScheduleException("UNIQUE_CHECK_FAILED", String.format("Error checking unique ID for %s at URL: %s", searchVal, url));
        }
    }

    public static long creatProject(String url, String token, String projectName, String description) {
        try {
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("projectName", projectName);
            queryParams.put("description", description);
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, POST, queryParams, header);
            JsonObject data = response.get("data").getAsJsonObject();
            LOGGER.info("create project success, project data: {}", (Object)data);
            return data != null ? data.get("code").getAsLong() : 0L;
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during creating project", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error creating project with name: %s and description: %s at URL: %s", projectName, description, url));
        }
        catch (DolphinScheduleException e) {
            LOGGER.error("Creating project failed: {}", (Object)e.getMessage());
            throw new DolphinScheduleException("PROJECT_CREATION_FAILED", String.format("Error creating project with name: %s and description: %s at URL: %s", projectName, description, url));
        }
    }

    public static Map<Long, String> queryAllProcessDef(String url, String token) {
        Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
        try {
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, GET, new HashMap<String, String>(), header);
            Map<Long, String> processDef = StreamSupport.stream(response.get("data").getAsJsonArray().spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jsonObject -> jsonObject.get("code").getAsLong(), jsonObject -> jsonObject.get("name").getAsString()));
            LOGGER.info("Query all process definition success, processes info: {}", processDef);
            return processDef;
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during query all process definition", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error querying all process definitions at URL: %s", url));
        }
        catch (DolphinScheduleException e) {
            LOGGER.info("Query all process definition failed: {}", (Object)e.getMessage());
            throw new DolphinScheduleException("PROCESS_DEFINITION_QUERY_FAILED", String.format("Error querying all process definitions at URL: %s", url));
        }
    }

    public static long genTaskCode(String url, String token) {
        try {
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("genNum", "1");
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, GET, queryParams, header);
            JsonArray data = response.get("data").getAsJsonArray();
            LOGGER.info("Generate task code success, task code data: {}", (Object)data);
            return data != null && data.size() == 1 ? data.get(0).getAsLong() : 0L;
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during generate task code", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error generate task code at URL: %s", url));
        }
        catch (DolphinScheduleException e) {
            LOGGER.info("generate task code failed: {}", (Object)e.getMessage());
            throw new DolphinScheduleException("GEN_TASK_CODE_FAILED", String.format("Error generate task code at URL: %s", url));
        }
    }

    public static long createProcessDef(String url, String token, String name, String desc, long taskCode, String inlongManagerUrl, String username, String password, long offset, String groupId) throws Exception {
        try {
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            DSTaskRelation taskRelation = new DSTaskRelation();
            taskRelation.setPostTaskCode(taskCode);
            String taskRelationJson = MAPPER.writeValueAsString(Collections.singletonList(taskRelation));
            DSTaskParams taskParams = new DSTaskParams();
            taskParams.setRawScript(DolphinScheduleUtils.buildScript(inlongManagerUrl, username, password, offset, groupId));
            DSTaskDefinition taskDefinition = new DSTaskDefinition();
            taskDefinition.setCode(taskCode);
            taskDefinition.setName("default-inlong-http-callback");
            taskDefinition.setDescription("default http request using shell script callbacks to inlong");
            taskDefinition.setTaskParams(taskParams);
            String taskDefinitionJson = MAPPER.writeValueAsString(Collections.singletonList(taskDefinition));
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("taskRelationJson", taskRelationJson);
            queryParams.put("taskDefinitionJson", taskDefinitionJson);
            queryParams.put("name", name);
            queryParams.put("description", desc);
            JsonObject data = DolphinScheduleUtils.executeHttpRequest(url, POST, queryParams, header);
            LOGGER.info("create process definition success, process definition data: {}", (Object)data);
            return data != null ? data.get("data").getAsJsonObject().get("code").getAsLong() : 0L;
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during creating process definition", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error creating process definition with name: %s and description: %s at URL: %s", name, desc, url));
        }
        catch (DolphinScheduleException e) {
            throw new DolphinScheduleException("PROCESS_DEFINITION_CREATION_FAILED", String.format("Error creating process definition with name: %s and description: %s at URL: %s", name, desc, url));
        }
    }

    public static boolean releaseProcessDef(String processDefUrl, long processDefCode, String token, String status) {
        try {
            String url = processDefUrl + "/" + processDefCode + "/release";
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            HashMap<String, String> queryParam = new HashMap<String, String>();
            queryParam.put("releaseState", status);
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, POST, queryParam, header);
            LOGGER.info("release process definition success, response data: {}", (Object)response);
            return response.get("data").getAsBoolean();
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during releasing process definition", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error releasing process definition with code: %d and status: %s at URL: %s", processDefCode, status, processDefUrl));
        }
        catch (DolphinScheduleException e) {
            throw new DolphinScheduleException("PROCESS_DEFINITION_RELEASE_FAILED", String.format("Error releasing process definition with code: %d and status: %s at URL: %s", processDefCode, status, processDefUrl));
        }
    }

    public static int createScheduleForProcessDef(String url, long processDefCode, String token, ScheduleInfo scheduleInfo) throws Exception {
        try {
            String crontab;
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String startTime = scheduleInfo.getStartTime().toLocalDateTime().atZone(ZoneId.of("Asia/Shanghai")).format(formatter);
            String endTime = scheduleInfo.getEndTime().toLocalDateTime().atZone(ZoneId.of("Asia/Shanghai")).format(formatter);
            switch (scheduleInfo.getScheduleType()) {
                case 0: {
                    crontab = DolphinScheduleUtils.generateCrontabExpression(scheduleInfo.getScheduleUnit(), scheduleInfo.getScheduleInterval());
                    break;
                }
                case 1: {
                    crontab = scheduleInfo.getCrontabExpression();
                    break;
                }
                default: {
                    LOGGER.error("Unsupported schedule type: {}", (Object)scheduleInfo.getScheduleType());
                    throw new DolphinScheduleException("Unsupported schedule type: " + scheduleInfo.getScheduleType());
                }
            }
            DScheduleInfo dScheduleInfo = new DScheduleInfo();
            dScheduleInfo.setStartTime(startTime);
            dScheduleInfo.setEndTime(endTime);
            dScheduleInfo.setCrontab(crontab);
            dScheduleInfo.setTimezoneId("Asia/Shanghai");
            String scheduleDef = MAPPER.writeValueAsString((Object)dScheduleInfo);
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("processDefinitionCode", String.valueOf(processDefCode));
            queryParams.put("schedule", scheduleDef);
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, POST, queryParams, header);
            LOGGER.info("create schedule for process definition success, response data: {}", (Object)response);
            return response.get("data").getAsJsonObject().get("id").getAsInt();
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during releasing process definition", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error creating schedule for process definition code: %d at URL: %s", processDefCode, url));
        }
        catch (DolphinScheduleException e) {
            throw new DolphinScheduleException("SCHEDULE_CREATION_FAILED", String.format("Error creating schedule for process definition code: %d at URL: %s", processDefCode, url));
        }
    }

    public static boolean onlineScheduleForProcessDef(String scheduleUrl, int scheduleId, String token) {
        try {
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            String url = scheduleUrl + "/" + scheduleId + "/online";
            JsonObject response = DolphinScheduleUtils.executeHttpRequest(url, POST, new HashMap<String, String>(), header);
            LOGGER.info("online schedule for process definition success, response data: {}", (Object)response);
            if (response != null && !response.get("data").isJsonNull()) {
                return response.get("data").getAsBoolean();
            }
            return false;
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during online schedule", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error online schedule with ID: %d online at URL: %s", scheduleId, scheduleUrl));
        }
        catch (DolphinScheduleException e) {
            throw new DolphinScheduleException("SCHEDULE_ONLINE_FAILED", String.format("Error online schedule with ID: %d online at URL: %s", scheduleId, scheduleUrl));
        }
    }

    public static void delete(String url, String token, long code) {
        try {
            Map<String, String> header = DolphinScheduleUtils.buildHeader(token);
            String requestUrl = url + "/" + code;
            for (int retryTime = 1; retryTime <= 3; ++retryTime) {
                JsonObject response = DolphinScheduleUtils.executeHttpRequest(requestUrl, DELETE, new HashMap<String, String>(), header);
                if (response.get("code").getAsInt() == 10163) {
                    LOGGER.warn("Retrying for current retry time ={}, maximum retry count={}, code={}, url={}, after {} ms...", new Object[]{retryTime, 3, code, url, 1000});
                    Thread.sleep(1000L);
                    continue;
                }
                if (response.get("success").getAsBoolean()) {
                    LOGGER.info("Delete process or project success, response data: {}", (Object)response);
                    return;
                }
                LOGGER.warn("Delete process or project failed, response data: {}", (Object)response);
            }
            LOGGER.error("Maximum retry attempts reached for deleting process or project. URL: {}, Code: {}", (Object)url, (Object)code);
            throw new DolphinScheduleException("DELETION_FAILED", String.format("Failed to delete after %d retries. Code: %d at URL: %s", 3, code, url));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Thread interrupted while retrying delete process or project: ", (Throwable)e);
            throw new DolphinScheduleException("DELETION_FAILED", String.format("Thread interrupted while retrying delete for code: %d at URL: %s", code, url));
        }
        catch (JsonParseException e) {
            LOGGER.error("JsonParseException during deleting process or project", (Throwable)e);
            throw new DolphinScheduleException("JSON_PARSE_ERROR", String.format("Error deleting process or project with code: %d at URL: %s", code, url));
        }
        catch (DolphinScheduleException e) {
            LOGGER.error("Error deleting process or project for code={}, url={} ", new Object[]{code, url, e});
            throw new DolphinScheduleException("DELETION_FAILED", String.format("Error deleting process or project with code: %d at URL: %s", code, url));
        }
    }

    private static Map<String, String> buildHeader(String token) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((CharSequence)token)) {
            headers.put("token", token);
        }
        return headers;
    }

    private static Map<String, String> buildPageParam(String searchVal) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("searchVal", searchVal);
        queryParams.put("pageSize", "10");
        queryParams.put("pageNo", "1");
        return queryParams;
    }

    public static long calculateOffset(ScheduleInfo scheduleInfo) {
        if (scheduleInfo == null) {
            LOGGER.error("ScheduleInfo cannot be null");
            throw new DolphinScheduleException("ScheduleInfo cannot be null");
        }
        long offset = 0L;
        if (scheduleInfo.getScheduleType() == null) {
            LOGGER.error("Schedule type cannot be null");
            throw new DolphinScheduleException("Schedule type cannot be null");
        }
        switch (scheduleInfo.getScheduleType()) {
            case 0: {
                offset = DolphinScheduleUtils.calculateNormalOffset(scheduleInfo);
                break;
            }
            case 1: {
                offset = DolphinScheduleUtils.calculateCronOffset(scheduleInfo);
                break;
            }
            default: {
                LOGGER.error("Invalid schedule type");
                throw new DolphinScheduleException("UNSUPPORTED_SCHEDULE_TYPE", "Invalid schedule type");
            }
        }
        if (scheduleInfo.getDelayTime() != null) {
            offset += (long)scheduleInfo.getDelayTime().intValue() * 1000L;
        }
        return offset;
    }

    private static long calculateNormalOffset(ScheduleInfo scheduleInfo) {
        if (scheduleInfo.getScheduleInterval() == null || scheduleInfo.getScheduleUnit() == null) {
            LOGGER.error("Schedule interval and unit cannot be null for normal scheduling");
            throw new IllegalArgumentException("Schedule interval and unit cannot be null for normal scheduling");
        }
        switch (Objects.requireNonNull(ScheduleUnit.getScheduleUnit(scheduleInfo.getScheduleUnit()))) {
            case YEAR: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 31536000000L;
            }
            case MONTH: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 2592000000L;
            }
            case WEEK: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 604800000L;
            }
            case DAY: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 86400000L;
            }
            case HOUR: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 3600000L;
            }
            case MINUTE: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 60000L;
            }
            case SECOND: {
                return (long)scheduleInfo.getScheduleInterval().intValue() * 1000L;
            }
            case ONE_ROUND: {
                return scheduleInfo.getScheduleInterval().intValue();
            }
        }
        LOGGER.error("Invalid schedule unit");
        throw new DolphinScheduleException("Invalid schedule unit");
    }

    private static long calculateCronOffset(ScheduleInfo scheduleInfo) {
        if (scheduleInfo.getCrontabExpression() == null) {
            LOGGER.error("Crontab expression cannot be null for schedule type crontab");
            throw new DolphinScheduleException("Crontab expression cannot be null for schedule type crontab");
        }
        try {
            CronExpression cronExpression = new CronExpression(scheduleInfo.getCrontabExpression());
            Date firstExecution = cronExpression.getNextValidTimeAfter(new Date());
            Date secondExecution = cronExpression.getNextValidTimeAfter(firstExecution);
            if (secondExecution != null) {
                return secondExecution.getTime() - firstExecution.getTime();
            }
            LOGGER.error("Unable to calculate the next execution times for the cron expression");
            throw new DolphinScheduleException("Unable to calculate the next execution times for the cron expression");
        }
        catch (Exception e) {
            LOGGER.error("Invalid cron expression: ", (Throwable)e);
            throw new DolphinScheduleException(String.format("Invalid cron expression: %s", e.getMessage()));
        }
    }

    private static String generateCrontabExpression(String scheduleUnit, Integer scheduleInterval) {
        String crontabExpression;
        if (scheduleUnit.isEmpty()) {
            LOGGER.error("Schedule unit and interval must not be null for generating crontab expression");
            throw new DolphinScheduleException("Schedule unit and interval must not be null for generating crontab expression");
        }
        switch (Objects.requireNonNull(ScheduleUnit.getScheduleUnit(scheduleUnit))) {
            case SECOND: {
                crontabExpression = String.format("0/%d * * * * ? *", scheduleInterval);
                break;
            }
            case MINUTE: {
                crontabExpression = String.format("* 0/%d * * * ? *", scheduleInterval);
                break;
            }
            case HOUR: {
                crontabExpression = String.format("* * 0/%d * * ? *", scheduleInterval);
                break;
            }
            case DAY: {
                crontabExpression = String.format("* * * 1/%d * ? *", scheduleInterval);
                break;
            }
            case WEEK: {
                crontabExpression = String.format("* * * 1/%d * ? *", scheduleInterval * 7);
                break;
            }
            case MONTH: {
                crontabExpression = String.format("* * * * 0/%d ? *", scheduleInterval);
                break;
            }
            case YEAR: {
                crontabExpression = String.format("* * * * * ? 0/%d", scheduleInterval);
                break;
            }
            default: {
                LOGGER.error("Unsupported schedule unit for generating crontab: {}", (Object)scheduleUnit);
                throw new DolphinScheduleException("Unsupported schedule unit for generating crontab: " + scheduleUnit);
            }
        }
        return crontabExpression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonObject executeHttpRequest(String url, String method, Map<String, String> queryParams, Map<String, String> headers) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        HttpUrl httpUrl = urlBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)CONTENT_TYPE), (String)"");
        switch (method.toUpperCase()) {
            case "POST": {
                requestBuilder.post(body);
                break;
            }
            case "GET": {
                requestBuilder.get();
                break;
            }
            case "DELETE": {
                requestBuilder.delete(body);
                break;
            }
            default: {
                throw new DolphinScheduleException("INVALID_HTTP_METHOD", String.format("Unsupported request method: %s", method));
            }
        }
        Request request = requestBuilder.build();
        try (Response response = CLIENT.newCall(request).execute();){
            String responseBody = response.body() != null ? response.body().string() : null;
            LOGGER.debug("HTTP request to {} completed with status code {}", (Object)httpUrl, (Object)response.code());
            if (response.isSuccessful() && responseBody != null) {
                JsonObject jsonObject = JsonParser.parseString((String)responseBody).getAsJsonObject();
                return jsonObject;
            }
            LOGGER.error("HTTP request to {} failed. HTTP Status: {}, Response Body: {}", new Object[]{httpUrl, response.code(), responseBody != null ? responseBody : "No response body"});
            throw new DolphinScheduleException("HTTP_REQUEST_FAILED", String.format("HTTP request to %s failed. Status: %d, Response: %s", httpUrl, response.code(), responseBody != null ? responseBody : "No response body"));
        }
        catch (IOException e) {
            throw new DolphinScheduleException("NETWORK_ERROR", String.format("Network error during HTTP request to %s. Reason: %s", httpUrl, e.getMessage()));
        }
        catch (Exception e) {
            throw new DolphinScheduleException("UNEXPECTED_ERROR", String.format("Unexpected error during HTTP request to %s. Reason: %s", httpUrl, e.getMessage()));
        }
    }

    private static String buildScript(String inlongManagerUrl, String username, String password, long offset, String groupId) {
        LOGGER.info("build script for Inlong Manager Url: {}, username: {}, password: {}, offset: {}, groupId: {}", new Object[]{inlongManagerUrl, username, password, offset, groupId});
        return "#!/bin/bash\n\n# Get current timestamp\nlowerBoundary=$(date +%s)\necho \"get lowerBoundary: ${lowerBoundary}\"\nupperBoundary=$(($lowerBoundary + " + offset + "))\necho \"get upperBoundary: ${upperBoundary}\"\n\n# Set URL and HTTP method\nurl=\"" + inlongManagerUrl + SHELL_REQUEST_API + "?username=" + username + "&password=" + password + "\"\necho \"get url: ${url}\"\nhttpMethod=\"POST\"\n\n# Build request body\njsonBody=$(cat <<EOF\n{\n  \"boundaryType\": \"" + BoundaryType.TIME.getType() + "\",\n  \"groupId\": \"" + groupId + "\",\n  \"lowerBoundary\": \"${lowerBoundary}\",\n  \"upperBoundary\": \"${upperBoundary}\"\n}\nEOF\n)\n\necho \"${jsonBody}\"\n\n# Send request\nresponse=$(curl -s -X \"$httpMethod\" \"$url\" \\\n  -H \"" + CONTENT_TYPE + "\" \\\n  -d \"$jsonBody\")\n\n# Log response\necho \"Request Sending success, Response: $response\"";
    }
}

