/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.InlongStream;
import org.apache.inlong.manager.client.api.InlongStreamBuilder;
import org.apache.inlong.manager.client.api.impl.InlongStreamImpl;
import org.apache.inlong.manager.client.api.inner.InnerGroupContext;
import org.apache.inlong.manager.client.api.inner.InnerStreamContext;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongStreamClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSinkClient;
import org.apache.inlong.manager.client.api.inner.client.StreamSourceClient;
import org.apache.inlong.manager.client.api.inner.client.StreamTransformClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.client.api.util.StreamTransformTransfer;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamPipeline;
import org.apache.inlong.manager.pojo.stream.StreamTransform;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultInlongStreamBuilder
extends InlongStreamBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultInlongStreamBuilder.class);
    private final InlongStreamImpl inlongStream;
    private final InnerStreamContext streamContext;
    private final InlongStreamClient streamClient;
    private final StreamSourceClient sourceClient;
    private final StreamSinkClient sinkClient;
    private final StreamTransformClient transformClient;

    public DefaultInlongStreamBuilder(InlongStreamInfo streamInfo, InnerGroupContext groupContext, ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.streamClient = clientFactory.getStreamClient();
        this.sourceClient = clientFactory.getSourceClient();
        this.sinkClient = clientFactory.getSinkClient();
        this.transformClient = clientFactory.getTransformClient();
        if (MapUtils.isEmpty(groupContext.getStreamContextMap())) {
            groupContext.setStreamContextMap(Maps.newHashMap());
        }
        InlongGroupInfo groupInfo = groupContext.getGroupInfo();
        String groupId = groupInfo.getInlongGroupId();
        streamInfo.setInlongGroupId(groupId);
        streamInfo.setCreator(groupInfo.getCreator());
        InnerStreamContext streamContext = new InnerStreamContext(streamInfo);
        groupContext.setStreamContext(streamContext);
        this.streamContext = streamContext;
        this.inlongStream = new InlongStreamImpl(groupId, streamInfo.getInlongStreamId(), configuration);
        if (CollectionUtils.isNotEmpty((Collection)streamInfo.getFieldList())) {
            this.inlongStream.setStreamFields(streamInfo.getFieldList());
        }
        groupContext.setStream(this.inlongStream);
    }

    @Override
    public InlongStreamBuilder source(StreamSource source) {
        InlongStreamInfo streamInfo = this.streamContext.getStreamInfo();
        source.setInlongGroupId(streamInfo.getInlongGroupId());
        source.setInlongStreamId(streamInfo.getInlongStreamId());
        this.inlongStream.addSource(source);
        this.streamContext.setSourceRequest(source.genSourceRequest());
        return this;
    }

    @Override
    public InlongStreamBuilder sink(StreamSink streamSink) {
        InlongStreamInfo streamInfo = this.streamContext.getStreamInfo();
        streamSink.setInlongGroupId(streamInfo.getInlongGroupId());
        streamSink.setInlongStreamId(streamInfo.getInlongStreamId());
        this.inlongStream.addSink(streamSink);
        this.streamContext.setSinkRequest(streamSink.genSinkRequest());
        return this;
    }

    @Override
    public InlongStreamBuilder fields(List<StreamField> fieldList) {
        this.inlongStream.setStreamFields(fieldList);
        this.streamContext.updateStreamFields(fieldList);
        return this;
    }

    @Override
    public InlongStreamBuilder transform(StreamTransform streamTransform) {
        this.inlongStream.addTransform(streamTransform);
        TransformRequest transformRequest = StreamTransformTransfer.createTransformRequest(streamTransform, this.streamContext.getStreamInfo());
        this.streamContext.setTransformRequest(transformRequest);
        return this;
    }

    @Override
    public InlongStream init() {
        InlongStreamInfo streamInfo = this.streamContext.getStreamInfo();
        StreamPipeline streamPipeline = this.inlongStream.createPipeline();
        streamInfo.setExtParams(JsonUtils.toJsonString((Object)streamPipeline));
        streamInfo.setId(this.streamClient.createStreamInfo(streamInfo));
        ArrayList sourceRequests = Lists.newArrayList(this.streamContext.getSourceRequests().values());
        for (Object sourceRequest : sourceRequests) {
            sourceRequest.setId(this.sourceClient.createSource((SourceRequest)sourceRequest));
        }
        ArrayList sinkRequests = Lists.newArrayList(this.streamContext.getSinkRequests().values());
        for (SinkRequest sinkRequest : sinkRequests) {
            sinkRequest.setId(this.sinkClient.createSink(sinkRequest));
        }
        ArrayList transformRequests = Lists.newArrayList(this.streamContext.getTransformRequests().values());
        for (TransformRequest transformRequest : transformRequests) {
            transformRequest.setId(this.transformClient.createTransform(transformRequest));
        }
        return this.inlongStream;
    }

    @Override
    public InlongStream initOrUpdate() {
        InlongStreamInfo dataStreamInfo = this.streamContext.getStreamInfo();
        StreamPipeline streamPipeline = this.inlongStream.createPipeline();
        dataStreamInfo.setExtParams(JsonUtils.toJsonString((Object)streamPipeline));
        InlongStreamInfo existStreamInfo = this.streamClient.getStreamIfExists(dataStreamInfo);
        if (existStreamInfo != null) {
            dataStreamInfo.setVersion(existStreamInfo.getVersion());
            Pair<Boolean, String> updateMsg = this.streamClient.updateStreamInfo(dataStreamInfo);
            if (!((Boolean)updateMsg.getKey()).booleanValue()) {
                throw new RuntimeException(String.format("Update data stream failed:%s", updateMsg.getValue()));
            }
            this.initOrUpdateTransform();
            this.initOrUpdateSource();
            this.initOrUpdateSink();
            return this.inlongStream;
        }
        return this.init();
    }

    private void initOrUpdateTransform() {
        Map<String, TransformRequest> transformRequests = this.streamContext.getTransformRequests();
        InlongStreamInfo streamInfo = this.streamContext.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        List transformResponses = this.transformClient.listTransform(groupId, streamId).getList();
        ArrayList updateTransformNames = Lists.newArrayList();
        for (TransformResponse transformResponse : transformResponses) {
            StreamTransform transform = StreamTransformTransfer.parseStreamTransform(transformResponse);
            String transformName = transform.getTransformName();
            int id = transformResponse.getId();
            if (transformRequests.get(transformName) != null) {
                TransformRequest transformRequest = transformRequests.get(transformName);
                transformRequest.setId(Integer.valueOf(id));
                transformRequest.setVersion(transformResponse.getVersion());
                Pair<Boolean, String> updateState = this.transformClient.updateTransform(transformRequest);
                if (!((Boolean)updateState.getKey()).booleanValue()) {
                    throw new RuntimeException(String.format("Update transform=%s failed with err=%s", transformRequest, updateState.getValue()));
                }
                transformRequest.setId(transformResponse.getId());
                updateTransformNames.add(transformName);
                continue;
            }
            log.warn("Unknown transform {} from server", (Object)transformName);
        }
        for (Map.Entry entry : transformRequests.entrySet()) {
            String transformName = (String)entry.getKey();
            if (updateTransformNames.contains(transformName)) continue;
            TransformRequest transformRequest = (TransformRequest)entry.getValue();
            transformRequest.setId(this.transformClient.createTransform(transformRequest));
        }
    }

    private void initOrUpdateSource() {
        String sourceName;
        Map<String, SourceRequest> sourceRequests = this.streamContext.getSourceRequests();
        InlongStreamInfo streamInfo = this.streamContext.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        List<StreamSource> streamSources = this.sourceClient.listSources(groupId, streamId);
        ArrayList updateSourceNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(streamSources)) {
            for (StreamSource streamSource : streamSources) {
                sourceName = streamSource.getSourceName();
                int id = streamSource.getId();
                if (sourceRequests.get(sourceName) != null) {
                    SourceRequest sourceRequest = sourceRequests.get(sourceName);
                    sourceRequest.setId(Integer.valueOf(id));
                    sourceRequest.setVersion(streamSource.getVersion());
                    Pair<Boolean, String> updateState = this.sourceClient.updateSource(sourceRequest);
                    if (!((Boolean)updateState.getKey()).booleanValue()) {
                        throw new RuntimeException(String.format("Update source=%s failed with err=%s", sourceRequest, updateState.getValue()));
                    }
                    updateSourceNames.add(sourceName);
                    sourceRequest.setId(streamSource.getId());
                    continue;
                }
                log.warn("Unknown source {} from server", (Object)sourceName);
            }
        }
        for (Map.Entry entry : sourceRequests.entrySet()) {
            sourceName = (String)entry.getKey();
            if (updateSourceNames.contains(sourceName)) continue;
            SourceRequest sourceRequest = (SourceRequest)entry.getValue();
            sourceRequest.setId(this.sourceClient.createSource(sourceRequest));
        }
    }

    private void initOrUpdateSink() {
        String sinkName;
        Map<String, SinkRequest> sinkRequests = this.streamContext.getSinkRequests();
        InlongStreamInfo streamInfo = this.streamContext.getStreamInfo();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        List<StreamSink> streamSinks = this.sinkClient.listSinks(groupId, streamId);
        ArrayList updateSinkNames = Lists.newArrayList();
        for (StreamSink streamSink : streamSinks) {
            sinkName = streamSink.getSinkName();
            int id = streamSink.getId();
            if (sinkRequests.get(sinkName) != null) {
                SinkRequest sinkRequest = sinkRequests.get(sinkName);
                sinkRequest.setId(Integer.valueOf(id));
                sinkRequest.setVersion(streamSink.getVersion());
                Pair<Boolean, String> updateState = this.sinkClient.updateSink(sinkRequest);
                if (!((Boolean)updateState.getKey()).booleanValue()) {
                    throw new RuntimeException(String.format("Update sink=%s failed with err=%s", sinkRequest, updateState.getValue()));
                }
                updateSinkNames.add(sinkName);
                sinkRequest.setId(streamSink.getId());
                continue;
            }
            log.warn("Unknown sink {} from server", (Object)sinkName);
        }
        for (Map.Entry entry : sinkRequests.entrySet()) {
            sinkName = (String)entry.getKey();
            if (updateSinkNames.contains(sinkName)) continue;
            SinkRequest sinkRequest = (SinkRequest)entry.getValue();
            sinkRequest.setId(this.sinkClient.createSink(sinkRequest));
        }
    }
}

