/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.expressions;

import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.planner.expressions.LeafExpression;
import org.apache.flink.table.planner.typeutils.TypeInfoCheckUtils$;
import org.apache.flink.table.planner.validate.ValidationFailure;
import org.apache.flink.table.planner.validate.ValidationResult;
import org.apache.flink.table.planner.validate.ValidationSuccess$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3Q!\u0001\u0002\u0002\u0002=\u0011\u0001cQ;se\u0016tG\u000fV5nKB{\u0017N\u001c;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u000fAd\u0017M\u001c8fe*\u0011q\u0001C\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u0013)\tQA\u001a7j].T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\bMK\u00064W\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011U\u0001!\u0011!Q\u0001\nY\t!\u0002^1sO\u0016$H+\u001f9fa\t92\u0005E\u0002\u0019?\u0005j\u0011!\u0007\u0006\u00035m\t\u0001\u0002^=qK&tgm\u001c\u0006\u00039u\taaY8n[>t'B\u0001\u0010\t\u0003\r\t\u0007/[\u0005\u0003Ae\u0011q\u0002V=qK&sgm\u001c:nCRLwN\u001c\t\u0003E\rb\u0001\u0001B\u0005%)\u0005\u0005\t\u0011!B\u0001K\t\u0019q\f\n\u001a\u0012\u0005\u0019b\u0003CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#a\u0002(pi\"Lgn\u001a\t\u0003O5J!A\f\u0015\u0003\u0007\u0005s\u0017\u0010\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003\u0015awnY1m!\t9#'\u0003\u00024Q\t9!i\\8mK\u0006t\u0007\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\bF\u00028qu\u0002\"!\u0005\u0001\t\u000bU!\u0004\u0019A\u001d1\u0005ib\u0004c\u0001\r wA\u0011!\u0005\u0010\u0003\nIa\n\t\u0011!A\u0003\u0002\u0015BQ\u0001\r\u001bA\u0002EBaa\u0010\u0001\u0005B!\u0001\u0015A\u0003:fgVdG\u000fV=qKV\t\u0011\t\r\u0002C\tB\u0019\u0001dH\"\u0011\u0005\t\"E!C#?\u0003\u0003\u0005\tQ!\u0001&\u0005\ryFe\r\u0005\u0007\u000f\u0002!\t\u0005\u0003%\u0002\u001bY\fG.\u001b3bi\u0016Le\u000e];u)\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0005\u0003!1\u0018\r\\5eCR,\u0017B\u0001(L\u0005A1\u0016\r\\5eCRLwN\u001c*fgVdG\u000fC\u0003Q\u0001\u0011\u0005\u0013+\u0001\u0005u_N#(/\u001b8h)\u0005\u0011\u0006CA*[\u001d\t!\u0006\f\u0005\u0002VQ5\taK\u0003\u0002X\u001d\u00051AH]8pizJ!!\u0017\u0015\u0002\rA\u0013X\rZ3g\u0013\tYFL\u0001\u0004TiJLgn\u001a\u0006\u00033\"\u0002")
public abstract class CurrentTimePoint
extends LeafExpression {
    private final TypeInformation<?> targetType;
    private final boolean local;

    @Override
    public TypeInformation<?> resultType() {
        return this.targetType;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ValidationResult validateInput() {
        ValidationResult validationResult;
        if (!TypeInfoCheckUtils$.MODULE$.isTimePoint(this.targetType)) {
            validationResult = new ValidationFailure(new StringBuilder(59).append("CurrentTimePoint operator requires Time Point target type, ").append(new StringBuilder(9).append("but get ").append(this.targetType).append(".").toString()).toString());
            return validationResult;
        }
        if (this.local) {
            TypeInformation<?> typeInformation = this.targetType;
            SqlTimeTypeInfo sqlTimeTypeInfo = SqlTimeTypeInfo.DATE;
            if (!(typeInformation != null ? !typeInformation.equals((Object)sqlTimeTypeInfo) : sqlTimeTypeInfo != null)) {
                validationResult = new ValidationFailure(new StringBuilder(70).append("Localized CurrentTimePoint operator requires Time or Timestamp target ").append(new StringBuilder(15).append("type, but get ").append(this.targetType).append(".").toString()).toString());
                return validationResult;
            }
        }
        validationResult = ValidationSuccess$.MODULE$;
        return validationResult;
    }

    public String toString() {
        return this.local ? new StringBuilder(7).append("local").append(this.targetType).append("()").toString() : new StringBuilder(9).append("current").append(this.targetType).append("()").toString();
    }

    public CurrentTimePoint(TypeInformation<?> targetType, boolean local) {
        this.targetType = targetType;
        this.local = local;
    }
}

