/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.physical.batch;

import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.Util;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.plan.cost.FlinkCost$;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalGroupAggregateBase;
import org.apache.flink.table.planner.plan.utils.FlinkRelMdUtil$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ea!B\u0001\u0003\u0003\u0003)\"A\b\"bi\u000eD\u0007\u000b[=tS\u000e\fG\u000eS1tQ\u0006;wM]3hCR,')Y:f\u0015\t\u0019A!A\u0003cCR\u001c\u0007N\u0003\u0002\u0006\r\u0005A\u0001\u000f[=tS\u000e\fGN\u0003\u0002\b\u0011\u0005)an\u001c3fg*\u0011\u0011BC\u0001\u0005a2\fgN\u0003\u0002\f\u0019\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0007\u000f\u0003\u0015!\u0018M\u00197f\u0015\ty\u0001#A\u0003gY&t7N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003?\t\u000bGo\u00195QQf\u001c\u0018nY1m\u000fJ|W\u000f]!hOJ,w-\u0019;f\u0005\u0006\u001cX\r\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u001d\u0019G.^:uKJ\u0004\"!H\u0011\u000e\u0003yQ!!C\u0010\u000b\u0005\u0001\u0002\u0012aB2bY\u000eLG/Z\u0005\u0003Ey\u0011QBU3m\u001fB$8\t\\;ti\u0016\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0011Q\u0014\u0018-\u001b;TKR\u0004\"!\b\u0014\n\u0005\u001dr\"a\u0003*fYR\u0013\u0018-\u001b;TKRD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\tS:\u0004X\u000f\u001e*fYB\u00111FL\u0007\u0002Y)\u0011QfH\u0001\u0004e\u0016d\u0017BA\u0018-\u0005\u001d\u0011V\r\u001c(pI\u0016D\u0001\"\r\u0001\u0003\u0002\u0003\u0006IAM\u0001\u000e_V$\b/\u001e;S_^$\u0016\u0010]3\u0011\u0005M2T\"\u0001\u001b\u000b\u0005Ub\u0013\u0001\u0002;za\u0016L!a\u000e\u001b\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\ns\u0001\u0011\t\u0011)A\u0005u\r\u000b\u0001b\u001a:pkBLgn\u001a\t\u0004wy\u0002U\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005m\n\u0015B\u0001\"=\u0005\rIe\u000e^\u0005\u0003saA\u0011\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u000f$\u0002\u0017\u0005,\bp\u0012:pkBLgnZ\u0005\u0003\u000bbA\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!S\u0001\u0015C\u001e<7)\u00197m)>\fum\u001a$v]\u000e$\u0018n\u001c8\u0011\u0007)\u0013VK\u0004\u0002L!:\u0011AjT\u0007\u0002\u001b*\u0011a\nF\u0001\u0007yI|w\u000e\u001e \n\u0003uJ!!\u0015\u001f\u0002\u000fA\f7m[1hK&\u00111\u000b\u0016\u0002\u0004'\u0016\f(BA)=!\u0011Yd\u000b\u00170\n\u0005]c$A\u0002+va2,'\u0007\u0005\u0002Z96\t!L\u0003\u0002\\Y\u0005!1m\u001c:f\u0013\ti&LA\u0007BO\u001e\u0014XmZ1uK\u000e\u000bG\u000e\u001c\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C2\t\u0011BZ;oGRLwN\\:\n\u0005\r\u0004'aE+tKJ$UMZ5oK\u00124UO\\2uS>t\u0007\"C3\u0001\u0005\u0003\u0005\u000b\u0011\u00024j\u0003\u001dI7/T3sO\u0016\u0004\"aO4\n\u0005!d$a\u0002\"p_2,\u0017M\\\u0005\u0003KbA\u0011b\u001b\u0001\u0003\u0002\u0003\u0006IA\u001a7\u0002\u000f%\u001ch)\u001b8bY&\u00111\u000e\u0007\u0005\u0006]\u0002!\ta\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015A\f(o\u001d;vm^D\u0018\u0010\u0005\u0002\u0018\u0001!)1$\u001ca\u00019!)A%\u001ca\u0001K!)\u0011&\u001ca\u0001U!)\u0011'\u001ca\u0001e!)\u0011(\u001ca\u0001u!)Q)\u001ca\u0001u!)\u0001*\u001ca\u0001\u0013\")Q-\u001ca\u0001M\")1.\u001ca\u0001M\")1\u0010\u0001C!y\u0006y1m\\7qkR,7+\u001a7g\u0007>\u001cH\u000fF\u0003~\u0003\u0003\tI\u0001\u0005\u0002\u001e}&\u0011qP\b\u0002\u000b%\u0016dw\n\u001d;D_N$\bBB\u0006{\u0001\u0004\t\u0019\u0001E\u0002\u001e\u0003\u000bI1!a\u0002\u001f\u00055\u0011V\r\\(qiBc\u0017M\u001c8fe\"9\u00111\u0002>A\u0002\u00055\u0011AA7r!\u0011\ty!!\u0006\u000e\u0005\u0005E!bAA\nY\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002\u0018\u0005E!\u0001\u0005*fY6+G/\u00193bi\u0006\fV/\u001a:z\u0001")
public abstract class BatchPhysicalHashAggregateBase
extends BatchPhysicalGroupAggregateBase {
    private final Seq<Tuple2<AggregateCall, UserDefinedFunction>> aggCallToAggFunction;

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double d;
        int numOfGroupKey = super.grouping().length;
        Double inputRowCnt = mq.getRowCount(this.getInput());
        if (inputRowCnt == null) {
            return null;
        }
        double hashCpuCost = (double)FlinkCost$.MODULE$.HASH_CPU_COST() * Predef$.MODULE$.Double2double(inputRowCnt) * (double)numOfGroupKey;
        double aggFunctionCpuCost = (double)FlinkCost$.MODULE$.FUNC_CPU_COST() * Predef$.MODULE$.Double2double(inputRowCnt) * (double)this.aggCallToAggFunction.size();
        if (numOfGroupKey == 0) {
            d = Predef$.MODULE$.Double2double(mq.getAverageRowSize(this));
        } else {
            double ndvOfGroupKey = Util.first(mq.getRowCount(this), 1.0);
            double bucketSize = ndvOfGroupKey * (double)16 / (double)FlinkCost$.MODULE$.HASH_COLLISION_WEIGHT();
            double recordSize = ndvOfGroupKey * (Predef$.MODULE$.Double2double(FlinkRelMdUtil$.MODULE$.binaryRowAverageSize(this)) + (double)8);
            d = bucketSize + recordSize;
        }
        double memCost = d;
        double cpuCost = hashCpuCost + aggFunctionCpuCost;
        Double rowCount = mq.getRowCount(this);
        FlinkCostFactory costFactory = (FlinkCostFactory)planner.getCostFactory();
        return costFactory.makeCost(Predef$.MODULE$.Double2double(rowCount), cpuCost, 0.0, 0.0, memCost);
    }

    public BatchPhysicalHashAggregateBase(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputRel, RelDataType outputRowType, int[] grouping, int[] auxGrouping, Seq<Tuple2<AggregateCall, UserDefinedFunction>> aggCallToAggFunction, boolean isMerge, boolean isFinal) {
        this.aggCallToAggFunction = aggCallToAggFunction;
        super(cluster, traitSet, inputRel, outputRowType, grouping, auxGrouping, aggCallToAggFunction, isMerge, isFinal);
    }
}

