/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.infinispan.commons.api.BasicCache;

public abstract class CacheSupport<K, V>
implements BasicCache<K, V> {
    protected long defaultLifespan;
    protected long defaultMaxIdleTime;

    protected CacheSupport() {
        this(0L, 0L);
    }

    protected CacheSupport(long defaultLifespan, long defaultMaxIdleTime) {
        this.defaultLifespan = defaultLifespan;
        this.defaultMaxIdleTime = defaultMaxIdleTime;
    }

    public final V put(K key, V value) {
        return (V)this.put(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    protected abstract void set(K var1, V var2);

    public final void putAll(Map<? extends K, ? extends V> map) {
        this.putAll(map, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value) {
        return (V)this.putIfAbsent(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final CompletableFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.put(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.putIfAbsent(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return (V)this.replace(key, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value) {
        return (V)this.replace(key, value, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return (V)this.merge(key, value, remappingFunction, this.defaultLifespan, TimeUnit.MILLISECONDS, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }

    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction, long lifespan, TimeUnit lifespanUnit) {
        return (V)this.merge(key, value, remappingFunction, lifespan, lifespanUnit, this.defaultMaxIdleTime, TimeUnit.MILLISECONDS);
    }
}

