/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cmd.shell;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.inlong.manager.service.cmd.shell.ShellExecutor;
import org.apache.inlong.manager.service.cmd.shell.ShellTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellExecutorImpl
implements ShellExecutor {
    private static final Logger log = LoggerFactory.getLogger(ShellExecutorImpl.class);
    private static final String[] EXCEPTION_REG = new String[]{"(.*)Caused by: (.*)Exception(.*)", "(.*)java.net.UnknownHostException(.*)", "(.*)Copy failed: java.io.IOException: Job failed!(.*)"};
    private ShellTracker tracker;

    public ShellExecutorImpl(ShellTracker tracker) {
        this.tracker = tracker;
    }

    private static long getPid(Process process) {
        try {
            Field f = process.getClass().getDeclaredField("pid");
            f.setAccessible(true);
            return f.getLong(process);
        }
        catch (Exception e) {
            log.error("get pid failed", (Throwable)e);
            return -1L;
        }
    }

    private static String[] merge(String shellPath, String[] paths) {
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(shellPath);
        cmds.addAll(Arrays.asList(paths));
        return cmds.toArray(new String[0]);
    }

    private static String arrayToString(Object[] array, String split) {
        if (array == null || array.length == 0) {
            return " ";
        }
        StringBuilder str = new StringBuilder();
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            if (i != 0) {
                str.append(split);
            }
            str.append(array[i]);
        }
        return str.toString();
    }

    private static boolean HasException(String str) {
        for (String reg : EXCEPTION_REG) {
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(str);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void syncExec(String shellPath, String ... params) {
        ArrayList<String> result = new ArrayList<String>();
        String[] cmds = ShellExecutorImpl.merge(shellPath, params);
        try {
            String line;
            Process ps = Runtime.getRuntime().exec(cmds);
            long pid = ShellExecutorImpl.getPid(ps);
            this.tracker.setProcessId(pid);
            BufferedReader br = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            boolean hasException = false;
            while ((line = br.readLine()) != null) {
                if (ShellExecutorImpl.HasException(line)) {
                    hasException = true;
                }
                result.add(line);
                this.tracker.setRunResult(ShellExecutorImpl.arrayToString(result.toArray(), "\n"));
                this.tracker.lineChange(line);
            }
            if (hasException) {
                this.tracker.lineChange("Java exception exist in output");
                this.tracker.setCode(-1);
                return;
            }
            ps.waitFor();
            int exitValue = ps.exitValue();
            if (exitValue != 0) {
                this.tracker.setCode(exitValue);
            }
        }
        catch (Exception e) {
            log.error("sync exec shell failed", (Throwable)e);
            result.add(e.getMessage());
            this.tracker.setRunResult(ShellExecutorImpl.arrayToString(result.toArray(), "\n"));
            this.tracker.lineChange(e.getMessage());
            this.tracker.setCode(-1);
        }
    }
}

