/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.consume;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ConsumeStatus;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongConsumeEntity;
import org.apache.inlong.manager.dao.mapper.InlongConsumeEntityMapper;
import org.apache.inlong.manager.pojo.common.CountInfo;
import org.apache.inlong.manager.pojo.common.OrderFieldEnum;
import org.apache.inlong.manager.pojo.common.OrderTypeEnum;
import org.apache.inlong.manager.pojo.common.PageRequest;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.consume.InlongConsumeBriefInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeCountInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumePageRequest;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.service.consume.InlongConsumeOperator;
import org.apache.inlong.manager.service.consume.InlongConsumeOperatorFactory;
import org.apache.inlong.manager.service.consume.InlongConsumeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InlongConsumeServiceImpl
implements InlongConsumeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongConsumeServiceImpl.class);
    private static final String AUTO_CREATE_MSG = "auto_create_by_system";
    @Autowired
    private InlongConsumeEntityMapper consumeMapper;
    @Autowired
    private InlongConsumeOperatorFactory consumeOperatorFactory;

    @Override
    public Integer save(InlongConsumeRequest request, String operator) {
        LOGGER.debug("begin to save inlong consume={} by user={}", (Object)request, (Object)operator);
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        Preconditions.expectNotBlank((String)request.getTopic(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong consume topic cannot be null");
        String consumerGroup = request.getConsumerGroup();
        Preconditions.expectNotBlank((String)consumerGroup, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"inlong consume topic cannot be null");
        if (this.consumerGroupExists(consumerGroup, request.getId())) {
            throw new BusinessException(String.format("consumer group %s already exist", consumerGroup));
        }
        InlongConsumeOperator consumeOperator = this.consumeOperatorFactory.getInstance(request.getMqType());
        Integer id = consumeOperator.saveOpt(request, operator);
        LOGGER.info("success to save inlong consume for consumer group={} by user={}", (Object)consumerGroup, (Object)operator);
        return id;
    }

    @Override
    public Integer saveBySystem(InlongGroupInfo groupInfo, String topic, String consumerGroup) {
        String groupId = groupInfo.getInlongGroupId();
        InlongConsumeEntity existEntity = this.consumeMapper.selectExists(consumerGroup, topic, groupId);
        if (existEntity != null) {
            LOGGER.warn("inlong consume already exists for groupId={} topic={} consumerGroup={}, skip to create", new Object[]{groupId, topic, consumerGroup});
            return existEntity.getId();
        }
        LOGGER.debug("begin to save inlong consume for groupId={} topic={} group={}", new Object[]{groupId, topic, consumerGroup});
        InlongConsumeEntity entity = new InlongConsumeEntity();
        entity.setConsumerGroup(consumerGroup);
        entity.setDescription(AUTO_CREATE_MSG);
        entity.setMqType(groupInfo.getMqType());
        entity.setTopic(topic);
        entity.setInlongGroupId(groupId);
        entity.setFilterEnabled(Integer.valueOf(0));
        entity.setInCharges(groupInfo.getInCharges());
        entity.setStatus(ConsumeStatus.APPROVE_PASSED.getCode());
        String operator = groupInfo.getCreator();
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.consumeMapper.insert(entity);
        LOGGER.debug("success save inlong consume for groupId={} topic={} group={}", new Object[]{groupId, topic, consumerGroup});
        return entity.getId();
    }

    @Override
    public boolean consumerGroupExists(String consumerGroup, Integer excludeSelfId) {
        InlongConsumePageRequest request = InlongConsumePageRequest.builder().consumerGroup(consumerGroup).isAdminRole(Boolean.valueOf(true)).build();
        List result = this.consumeMapper.selectByCondition(request);
        if (excludeSelfId != null) {
            result = result.stream().filter(consumer -> !excludeSelfId.equals(consumer.getId())).collect(Collectors.toList());
        }
        return CollectionUtils.isNotEmpty((Collection)result);
    }

    @Override
    public InlongConsumeInfo get(Integer id, String currentUser) {
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        InlongConsumeEntity entity = this.consumeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("inlong consume not found with id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CONSUME_NOT_FOUND);
        }
        InlongConsumeOperator consumeOperator = this.consumeOperatorFactory.getInstance(entity.getMqType());
        InlongConsumeInfo consumeInfo = consumeOperator.getFromEntity(entity);
        LOGGER.debug("success to get inlong consume for id={}", (Object)id);
        return consumeInfo;
    }

    @Override
    public InlongConsumeCountInfo countStatus(String username) {
        List countInfoList = this.consumeMapper.countByUser(username);
        InlongConsumeCountInfo result = new InlongConsumeCountInfo();
        for (CountInfo countInfo : countInfoList) {
            int status = Integer.parseInt(countInfo.getKey());
            int count = countInfo.getValue();
            result.setTotalCount(Integer.valueOf(result.getTotalCount() + count));
            if (status == ConsumeStatus.TO_BE_SUBMIT.getCode()) {
                result.setWaitAssignCount(Integer.valueOf(result.getWaitAssignCount() + count));
                continue;
            }
            if (status == ConsumeStatus.TO_BE_APPROVAL.getCode()) {
                result.setWaitApproveCount(Integer.valueOf(result.getWaitApproveCount() + count));
                continue;
            }
            if (status != ConsumeStatus.APPROVE_REJECTED.getCode()) continue;
            result.setRejectCount(Integer.valueOf(result.getRejectCount() + count));
        }
        LOGGER.debug("success to count inlong consume for user={}", (Object)username);
        return result;
    }

    @Override
    public PageResult<InlongConsumeBriefInfo> list(InlongConsumePageRequest request) {
        if (request.getPageSize() > PageRequest.MAX_PAGE_SIZE) {
            LOGGER.warn("list inlong consumes, change page size from {} to {}", (Object)request.getPageSize(), (Object)PageRequest.MAX_PAGE_SIZE);
            request.setPageSize(PageRequest.MAX_PAGE_SIZE.intValue());
        }
        PageHelper.startPage((int)request.getPageNum(), (int)request.getPageSize());
        OrderFieldEnum.checkOrderField((PageRequest)request);
        OrderTypeEnum.checkOrderType((PageRequest)request);
        Page briefInfos = (Page)this.consumeMapper.selectBriefList(request);
        PageResult pageResult = PageResult.fromPage((Page)briefInfos);
        LOGGER.debug("success to list inlong consume for {}", (Object)request);
        return pageResult;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRES_NEW)
    public Integer update(InlongConsumeRequest request, String operator) {
        LOGGER.debug("begin to update inlong consume={} by user={}", (Object)request, (Object)operator);
        Preconditions.expectNotNull((Object)request, (String)"inlong consume request cannot be null");
        Integer consumeId = request.getId();
        InlongConsumeEntity existEntity = this.consumeMapper.selectById(consumeId);
        Preconditions.expectNotNull((Object)existEntity, (String)("inlong consume not exist with id " + consumeId));
        if (!Objects.equals(existEntity.getVersion(), request.getVersion())) {
            LOGGER.error(String.format("inlong consume has already updated, id=%s, curVersion=%s", existEntity.getId(), request.getVersion()));
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        ConsumeStatus consumeStatus = ConsumeStatus.forCode((int)existEntity.getStatus());
        Preconditions.expectTrue((boolean)ConsumeStatus.allowedUpdate((ConsumeStatus)consumeStatus), (String)("inlong consume not allowed update when status is " + consumeStatus.name()));
        InlongConsumeOperator consumeOperator = this.consumeOperatorFactory.getInstance(request.getMqType());
        consumeOperator.updateOpt(request, operator);
        LOGGER.info("success to update inlong consume={} by user={}", (Object)request, (Object)operator);
        return consumeId;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ, propagation=Propagation.REQUIRES_NEW)
    public Boolean updateStatus(Integer id, Integer status, String operator) {
        ConsumeStatus nextStatus;
        LOGGER.info("begin to update consume status to [{}] for id={} by user={}", new Object[]{status, id, operator});
        Preconditions.expectNotNull((Object)id, (String)ErrorCodeEnum.ID_IS_EMPTY.getMessage());
        InlongConsumeEntity entity = this.consumeMapper.selectById(id);
        if (entity == null) {
            LOGGER.error("inlong consume not found by id={}", (Object)id);
            throw new BusinessException(ErrorCodeEnum.CONSUME_NOT_FOUND);
        }
        ConsumeStatus curStatus = ConsumeStatus.forCode((int)entity.getStatus());
        if (ConsumeStatus.notAllowedTransfer((ConsumeStatus)curStatus, (ConsumeStatus)(nextStatus = ConsumeStatus.forCode((int)status)))) {
            String errorMsg = String.format("Current status=%s cannot transfer to status=%s", curStatus, nextStatus);
            LOGGER.error(errorMsg);
            throw new BusinessException(errorMsg);
        }
        this.consumeMapper.updateStatus(id, status, operator);
        LOGGER.info("success to update consume status to [{}] for id={} by user={}", new Object[]{status, id, operator});
        return true;
    }

    @Override
    public Boolean delete(Integer id, String operator) {
        LOGGER.info("begin to delete inlong consume for id={} by user={}", (Object)id, (Object)operator);
        Preconditions.expectNotNull((Object)id, (String)"inlong consume id cannot be null");
        InlongConsumeEntity entity = this.consumeMapper.selectById(id);
        Preconditions.expectNotNull((Object)entity, (String)("inlong consume not exist with id " + id));
        entity.setIsDeleted(id);
        entity.setStatus(ConsumeStatus.DELETED.getCode());
        entity.setModifier(operator);
        int rowCount = this.consumeMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("inlong consume has already updated with id={}, curVersion={}", (Object)id, (Object)entity.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        LOGGER.info("success to delete inlong consume for id={} by user={}", (Object)id, (Object)operator);
        return true;
    }
}

