/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.Objects;
import org.apache.inlong.manager.dao.entity.DBCollectorDetailTaskEntity;
import org.apache.inlong.manager.dao.mapper.DBCollectorDetailTaskMapper;
import org.apache.inlong.manager.pojo.dbcollector.DBCollectorReportTaskRequest;
import org.apache.inlong.manager.pojo.dbcollector.DBCollectorTaskInfo;
import org.apache.inlong.manager.pojo.dbcollector.DBCollectorTaskRequest;
import org.apache.inlong.manager.service.core.DBCollectorTaskService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class DBCollectorTaskServiceImpl
implements DBCollectorTaskService {
    private static final Logger log = LoggerFactory.getLogger(DBCollectorTaskServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DBCollectorTaskServiceImpl.class);
    private static final String INTERFACE_VERSION = "1.0";
    private static final int INIT = 0;
    private static final int DISPATCHED = 1;
    private static final int DONE = 2;
    private static final int FAILED = 3;
    private static final int RETURN_SUCC = 0;
    private static final int RETURN_EMPTY = 1;
    private static final int RETURN_INVALID_VERSION = 2;
    private static final int RETURN_INVALID_STATE = 3;
    @Autowired
    private DBCollectorDetailTaskMapper detailTaskMapper;

    @Override
    public DBCollectorTaskInfo getTask(DBCollectorTaskRequest req) {
        LOGGER.debug("db collector task request: {}", (Object)req);
        if (!INTERFACE_VERSION.equals(req.getVersion())) {
            return DBCollectorTaskInfo.builder().version(INTERFACE_VERSION).returnCode(2).build();
        }
        DBCollectorDetailTaskEntity entity = this.detailTaskMapper.selectOneByState(0);
        if (entity == null) {
            return DBCollectorTaskInfo.builder().version(INTERFACE_VERSION).returnCode(1).build();
        }
        int ret = this.detailTaskMapper.changeState(entity.getId().intValue(), 0, 0, 1);
        if (ret == 0) {
            return DBCollectorTaskInfo.builder().version(INTERFACE_VERSION).returnCode(1).build();
        }
        DBCollectorTaskInfo.TaskInfo task = new DBCollectorTaskInfo.TaskInfo();
        task.setId(entity.getId().intValue());
        task.setType(entity.getType().intValue());
        task.setDBType(entity.getDbType().intValue());
        task.setIp(entity.getIp());
        task.setDBPort(entity.getPort().intValue());
        task.setDBName(entity.getDbName());
        task.setUser(entity.getUser());
        task.setPassword(entity.getPassword());
        task.setSqlStatement(entity.getSqlStatement());
        task.setTotalLimit(entity.getTotalLimit().intValue());
        task.setOnceLimit(entity.getOnceLimit().intValue());
        task.setTimeLimit(entity.getTimeLimit().intValue());
        task.setRetryTimes(entity.getRetryTimes().intValue());
        task.setInlongGroupId(entity.getGroupId());
        task.setInlongStreamId(entity.getStreamId());
        return DBCollectorTaskInfo.builder().version(INTERFACE_VERSION).returnCode(0).data(task).build();
    }

    @Override
    public Integer reportTask(DBCollectorReportTaskRequest req) {
        if (!Objects.equals(req.getVersion(), INTERFACE_VERSION)) {
            return 2;
        }
        DBCollectorDetailTaskEntity entity = this.detailTaskMapper.selectByTaskId(req.getId());
        if (entity == null) {
            return 1;
        }
        if (req.getState() != 1 && req.getState() != 2 && req.getState() != 3) {
            return 3;
        }
        int ret = this.detailTaskMapper.changeState(entity.getId().intValue(), req.getOffset(), 1, req.getState());
        if (ret == 0) {
            return 1;
        }
        return 0;
    }
}

