/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.source;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.listener.source.AbstractSourceOperateListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.springframework.stereotype.Component;

@Component
public class SourceRestartListener
extends AbstractSourceOperateListener {
    public String name() {
        return this.getClass().getSimpleName();
    }

    public boolean accept(WorkflowContext context) {
        if (!this.isGroupProcessForm(context)) {
            return false;
        }
        GroupResourceProcessForm processForm = (GroupResourceProcessForm)context.getProcessForm();
        return InlongConstants.STANDARD_MODE.equals(processForm.getGroupInfo().getInlongGroupMode()) && processForm.getGroupOperateType() == GroupOperateType.RESTART;
    }

    @Override
    public void operateStreamSource(SourceRequest sourceRequest, String operator) {
        if (CollectionUtils.isNotEmpty((Collection)sourceRequest.getDataAddTaskList())) {
            return;
        }
        this.streamSourceService.restart(sourceRequest.getId(), operator);
    }
}

