/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.stream;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.ProcessEvent;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdateStreamListener
implements ProcessEventListener {
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String operator = context.getOperator();
        GroupOperateType operateType = form.getGroupOperateType();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        switch (operateType) {
            case SUSPEND: {
                this.streamService.updateStatus(groupId, streamId, StreamStatus.CONFIG_OFFLINE_ING.getCode(), operator);
                break;
            }
            case RESTART: {
                this.streamService.updateStatus(groupId, streamId, StreamStatus.CONFIG_ONLINE_ING.getCode(), operator);
                break;
            }
            case DELETE: {
                this.streamService.updateStatus(groupId, streamId, StreamStatus.DELETING.getCode(), operator);
                break;
            }
        }
        return ListenerResult.success();
    }
}

