/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.kudu;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.kudu.KuduColumnInfo;
import org.apache.inlong.manager.pojo.sink.kudu.KuduSinkDTO;
import org.apache.inlong.manager.pojo.sink.kudu.KuduTableInfo;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.kudu.KuduResourceClient;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KuduResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuduResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "KUDU".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTableIfAbsent(sinkInfo);
    }

    private KuduSinkDTO getKuduInfo(SinkInfo sinkInfo) {
        return KuduSinkDTO.getFromJson((String)sinkInfo.getExtParams());
    }

    private void createTableIfAbsent(SinkInfo sinkInfo) {
        LOGGER.info("begin to create kudu table for sinkInfo={}", (Object)sinkInfo);
        KuduSinkDTO kuduInfo = this.getKuduInfo(sinkInfo);
        List<KuduColumnInfo> columnInfoList = this.getColumnList(sinkInfo);
        if (CollectionUtils.isEmpty(columnInfoList)) {
            throw new IllegalArgumentException("no kudu columns specified");
        }
        KuduTableInfo tableInfo = KuduSinkDTO.getKuduTableInfo((KuduSinkDTO)kuduInfo, columnInfoList);
        String masters = kuduInfo.getMasters();
        String tableName = kuduInfo.getTableName();
        try (KuduResourceClient client = null;){
            client = new KuduResourceClient(masters);
            boolean tableExists = client.tableExist(tableName);
            if (!tableExists) {
                client.createTable(tableName, tableInfo);
            } else {
                List<KuduColumnInfo> existColumns = client.getColumns(tableName);
                Set existColumnNameSet = existColumns.stream().map(SinkField::getFieldName).collect(Collectors.toSet());
                List<KuduColumnInfo> needAddColumns = tableInfo.getColumns().stream().filter(columnInfo -> !existColumnNameSet.contains(columnInfo.getFieldName())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    client.addColumns(tableName, needAddColumns);
                    LOGGER.info("{} columns added for kudu table {}", (Object)needAddColumns.size(), (Object)tableName);
                }
            }
            String info = "success to create Kudu resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo = {}", (Object)info);
        }
    }

    private List<KuduColumnInfo> getColumnList(SinkInfo sinkInfo) {
        List fieldList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        ArrayList<KuduColumnInfo> columnList = new ArrayList<KuduColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            KuduColumnInfo kuduColumnInfo;
            if (StringUtils.isNotBlank((CharSequence)field.getExtParams())) {
                kuduColumnInfo = KuduColumnInfo.getFromJson((String)field.getExtParams());
                CommonBeanUtils.copyProperties((Object)field, (Object)kuduColumnInfo, (boolean)true);
                columnList.add(kuduColumnInfo);
                continue;
            }
            kuduColumnInfo = new KuduColumnInfo();
            CommonBeanUtils.copyProperties((Object)field, (Object)kuduColumnInfo, (boolean)true);
            columnList.add(kuduColumnInfo);
        }
        return columnList;
    }
}

