/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.mysql;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.inlong.manager.common.util.UrlVerificationUtils;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLTableInfo;
import org.apache.inlong.manager.service.resource.sink.mysql.MySQLSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLJdbcUtils {
    private static final String MYSQL_JDBC_PREFIX = "jdbc:mysql://";
    private static final String MYSQL_DRIVER_CLASS = "com.mysql.cj.jdbc.Driver";
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        UrlVerificationUtils.extractHostAndValidatePortFromJdbcUrl((String)url, (String)MYSQL_JDBC_PREFIX);
        Connection conn = MySQLJdbcUtils.establishDatabaseConnection(url, user, password);
        return conn;
    }

    private static Connection establishDatabaseConnection(String url, String user, String password) throws Exception {
        Connection conn;
        try {
            Class.forName(MYSQL_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "Failed to get MySQL connection, please check MySQL JDBC URL, username, or password!";
            LOGGER.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg + " Other error message: " + e.getMessage());
        }
        LOGGER.info("get MySQL connection success for url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOGGER.info("execute sql [{}] success", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
            LOGGER.info("execute sql [{}] success", sqls);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    public static void createDb(Connection conn, String dbName) throws Exception {
        if (!MySQLJdbcUtils.checkDbExist(conn, dbName)) {
            String createDbSql = MySQLSqlBuilder.buildCreateDbSql(dbName);
            MySQLJdbcUtils.executeSql(conn, createDbSql);
            LOGGER.info("execute sql [{}] success", (Object)createDbSql);
        } else {
            LOGGER.info("The database [{}] are exists", (Object)dbName);
        }
    }

    public static boolean checkDbExist(Connection conn, String dbName) throws Exception {
        String checkDbSql = MySQLSqlBuilder.getCheckDatabase(dbName);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkDbSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                LOGGER.info("check db exist for db={}, result=true", (Object)dbName);
                boolean bl = true;
                return bl;
            }
        }
        LOGGER.info("check db exist for db={}, result=false", (Object)dbName);
        return false;
    }

    public static void createTable(Connection conn, MySQLTableInfo tableInfo) throws Exception {
        if (MySQLJdbcUtils.checkTablesExist(conn, tableInfo.getDbName(), tableInfo.getTableName())) {
            LOGGER.info("The table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            String createTableSql = MySQLSqlBuilder.buildCreateTableSql(tableInfo);
            MySQLJdbcUtils.executeSql(conn, createTableSql);
            LOGGER.info("execute sql [{}] success", (Object)createTableSql);
        }
    }

    public static boolean checkTablesExist(Connection conn, String dbName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = MySQLSqlBuilder.getCheckTable(dbName, tableName);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOGGER.info("check table exist for db={} table={}, result={}", new Object[]{dbName, tableName, result});
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String dbName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkTableSql = MySQLSqlBuilder.getCheckColumn(dbName, tableName, column);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOGGER.info("check column exist for db={} table={}, result={} column={}", new Object[]{dbName, tableName, result, column});
        return result;
    }

    public static List<MySQLColumnInfo> getColumns(Connection conn, String dbName, String tableName) throws Exception {
        String querySql = MySQLSqlBuilder.buildDescTableSql(dbName, tableName);
        ArrayList<MySQLColumnInfo> columnList = new ArrayList<MySQLColumnInfo>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            if (Objects.nonNull(rs)) {
                while (rs.next()) {
                    MySQLColumnInfo columnInfo = new MySQLColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3));
                    columnList.add(columnInfo);
                }
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String dbName, String tableName, List<MySQLColumnInfo> columns) throws Exception {
        ArrayList columnInfos = Lists.newArrayList();
        for (MySQLColumnInfo columnInfo : columns) {
            if (MySQLJdbcUtils.checkColumnExist(conn, dbName, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = MySQLSqlBuilder.buildAddColumnsSql(dbName, tableName, columnInfos);
        MySQLJdbcUtils.executeSqlBatch(conn, addColumnSql);
    }
}

