/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.oracle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.oracle.OracleColumnInfo;
import org.apache.inlong.manager.pojo.sink.oracle.OracleTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSqlBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OracleSqlBuilder.class);

    public static String getCheckTable(String userName, String tableName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT COUNT(*) FROM ALL_TABLES WHERE OWNER = UPPER('").append(userName).append("') ").append("AND TABLE_NAME = '").append(tableName).append("' ");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static String getCheckColumn(String tableName, String columnName) {
        StringBuilder sqlBuilder = new StringBuilder().append("SELECT count(1) ").append(" from  USER_TAB_COLUMNS where TABLE_NAME= '").append(tableName).append("' and COLUMN_NAME = '").append(columnName).append("' ");
        LOGGER.info("check table sql: {}", (Object)sqlBuilder);
        return sqlBuilder.toString();
    }

    public static List<String> buildCreateTableSql(OracleTableInfo table) {
        StringBuilder createSql = new StringBuilder().append("CREATE TABLE ").append(table.getUserName()).append(".\"").append(table.getTableName()).append("\"").append(OracleSqlBuilder.buildCreateColumnsSql(table));
        ArrayList sqls = Lists.newArrayList((Object[])new String[]{createSql.toString()});
        sqls.addAll(OracleSqlBuilder.getColumnsComment(table.getTableName(), table.getColumns()));
        LOGGER.info("create table sql size: {}", (Object)sqls.size());
        return sqls;
    }

    public static List<String> buildAddColumnsSql(String tableName, List<OracleColumnInfo> columnList) {
        ArrayList<String> resultList = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        columnList.forEach(columnInfo -> {
            resultList.add(sqlBuilder.append("ALTER TABLE \"").append(tableName).append("\" ADD \"").append(columnInfo.getName()).append("\" ").append(columnInfo.getType()).append(" ").toString());
            sqlBuilder.delete(0, sqlBuilder.length());
        });
        resultList.addAll(OracleSqlBuilder.getColumnsComment(tableName, columnList));
        LOGGER.info("add columns sql={}", resultList);
        return resultList;
    }

    private static String buildCreateColumnsSql(OracleTableInfo table) {
        List<String> columnList = OracleSqlBuilder.getColumnsInfo(table.getColumns());
        StringBuilder sql = new StringBuilder().append(" (").append(StringUtils.join(columnList, (String)",")).append(") ");
        LOGGER.info("create columns sql={}", (Object)sql);
        return sql.toString();
    }

    private static List<String> getColumnsInfo(List<OracleColumnInfo> columns) {
        ArrayList<String> columnList = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        columns.forEach(columnInfo -> {
            columnList.add(sqlBuilder.append("\"").append(columnInfo.getName()).append("\" ").append(columnInfo.getType()).toString());
            sqlBuilder.delete(0, sqlBuilder.length());
        });
        return columnList;
    }

    private static List<String> getColumnsComment(String tableName, List<OracleColumnInfo> columns) {
        ArrayList<String> commentList = new ArrayList<String>();
        StringBuilder sqlBuilder = new StringBuilder();
        columns.stream().filter(columnInfo -> StringUtils.isNotBlank((CharSequence)columnInfo.getComment())).forEach(columnInfo -> {
            sqlBuilder.append("COMMENT ON COLUMN \"").append(tableName).append("\".\"").append(columnInfo.getName()).append("\" IS '").append(columnInfo.getComment()).append("' ");
            commentList.add(sqlBuilder.toString());
            sqlBuilder.delete(0, sqlBuilder.length());
        });
        return commentList;
    }

    public static String buildDescTableSql(String tableName) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT A.COLUMN_NAME,A.DATA_TYPE,B.COMMENTS ").append(" FROM USER_TAB_COLUMNS A LEFT JOIN USER_COL_COMMENTS B ").append("  ON A.TABLE_NAME=B.TABLE_NAME AND A.COLUMN_NAME=B.COLUMN_NAME ").append("WHERE  A.TABLE_NAME = '").append(tableName).append("'  ORDER  BY A.COLUMN_ID ");
        LOGGER.info("desc table sql={}", (Object)sql);
        return sql.toString();
    }
}

