/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.starrocks;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.inlong.manager.common.util.UrlVerificationUtils;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksColumnInfo;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksTableInfo;
import org.apache.inlong.manager.service.resource.sink.starrocks.StarRocksSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksJdbcUtils {
    private static final String STAR_ROCKS_DRIVER_CLASS = "com.mysql.cj.jdbc.Driver";
    private static final String METADATA_TYPE = "TABLE";
    private static final String COLUMN_LABEL = "TABLE_NAME";
    private static final String STAR_ROCKS_JDBC_PREFIX = "jdbc:mysql://";
    private static final Logger LOGGER = LoggerFactory.getLogger(StarRocksJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        UrlVerificationUtils.extractHostAndValidatePortFromJdbcUrl((String)url, (String)STAR_ROCKS_JDBC_PREFIX);
        try {
            Class.forName(STAR_ROCKS_DRIVER_CLASS);
            Connection conn = DriverManager.getConnection(url, user, password);
            LOGGER.info("Successfully obtained StarRocks connection, URL: {}", (Object)url);
            return conn;
        }
        catch (Exception e) {
            String errMsg = "Failed to get StarRocks connection, please check StarRocks JDBC URL, username, or password.";
            LOGGER.error(errMsg, (Throwable)e);
            throw new Exception(errMsg + ", error: " + e.getMessage());
        }
    }

    public static void executeSql(String sql, String url, String user, String password) throws Exception {
        try (Connection conn = StarRocksJdbcUtils.getConnection(url, user, password);
             Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOGGER.info("execute sql [{}] success", (Object)sql);
        }
    }

    public static void createDb(String url, String username, String password, String dbName) throws Exception {
        String createDbSql = StarRocksSqlBuilder.buildCreateDbSql(dbName);
        StarRocksJdbcUtils.executeSql(createDbSql, url, username, password);
    }

    public static void createTable(String url, String username, String password, StarRocksTableInfo tableInfo) throws Exception {
        if (StarRocksJdbcUtils.checkTablesExist(url, username, password, tableInfo.getDbName(), tableInfo.getTableName())) {
            LOGGER.info("The table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            String createTableSql = StarRocksSqlBuilder.buildCreateTableSql(tableInfo);
            StarRocksJdbcUtils.executeSql(createTableSql, url, username, password);
            LOGGER.info("execute sql [{}] success", (Object)createTableSql);
        }
    }

    public static List<String> getTables(String url, String user, String password, String dbName) throws Exception {
        try (Connection conn = StarRocksJdbcUtils.getConnection(url, user, password);){
            HiveDatabaseMetaData metaData = (HiveDatabaseMetaData)conn.getMetaData();
            ResultSet rs = metaData.getTables(dbName, dbName, null, new String[]{METADATA_TYPE});
            ArrayList<String> tables = new ArrayList<String>();
            while (rs.next()) {
                String tableName = rs.getString(COLUMN_LABEL);
                tables.add(tableName);
            }
            rs.close();
            ArrayList<String> arrayList = tables;
            return arrayList;
        }
    }

    public static void addColumns(String url, String user, String password, String dbName, String tableName, List<StarRocksColumnInfo> columnList) throws Exception {
        ArrayList columnInfos = Lists.newArrayList();
        for (StarRocksColumnInfo columnInfo : columnList) {
            if (StarRocksJdbcUtils.checkColumnExist(url, user, password, dbName, tableName, columnInfo.getFieldName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = StarRocksSqlBuilder.buildAddColumnsSql(dbName, tableName, columnInfos);
        try (Connection conn = StarRocksJdbcUtils.getConnection(url, user, password);){
            StarRocksJdbcUtils.executeSqlBatch(conn, addColumnSql);
        }
    }

    public static boolean checkTablesExist(String url, String user, String password, String dbName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = StarRocksSqlBuilder.getCheckTable(dbName, tableName);
        try (Connection conn = StarRocksJdbcUtils.getConnection(url, user, password);
             Statement stmt = conn.createStatement();){
            ResultSet resultSet = stmt.executeQuery(checkTableSql);
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOGGER.info("check table exist for db={} table={}, result={}", new Object[]{dbName, tableName, result});
        return result;
    }

    public static boolean checkColumnExist(String url, String user, String password, String dbName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkTableSql = StarRocksSqlBuilder.getCheckColumn(dbName, tableName, column);
        try (Connection conn = StarRocksJdbcUtils.getConnection(url, user, password);
             Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOGGER.info("check column exist for db={} table={}, result={} column={}", new Object[]{dbName, tableName, result, column});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
            LOGGER.info("execute sql [{}] success", sqls);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }
}

