/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.bounded;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;

public enum BoundedSourceType {
    PULSAR("pulsar");

    private final String sourceType;

    private BoundedSourceType(String name) {
        this.sourceType = name;
    }

    public static BoundedSourceType getInstance(String name) {
        for (BoundedSourceType source : BoundedSourceType.values()) {
            if (!source.getSourceType().equalsIgnoreCase(name)) continue;
            return source;
        }
        throw new BusinessException(ErrorCodeEnum.BOUNDED_SOURCE_TYPE_NOT_SUPPORTED, String.format(ErrorCodeEnum.BOUNDED_SOURCE_TYPE_NOT_SUPPORTED.getMessage(), name));
    }

    public static boolean isBoundedSource(String name) {
        for (BoundedSourceType source : BoundedSourceType.values()) {
            if (!source.getSourceType().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String getSourceType() {
        return this.sourceType;
    }
}

