/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.postgresql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.pojo.node.postgresql.PostgreSQLDataNodeInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.postgresql.PostgreSQLSource;
import org.apache.inlong.manager.pojo.source.postgresql.PostgreSQLSourceDTO;
import org.apache.inlong.manager.pojo.source.postgresql.PostgreSQLSourceRequest;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.service.source.AbstractSourceOperator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostgreSQLSourceOperator
extends AbstractSourceOperator {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sourceType) {
        return "POSTGRESQL".equals(sourceType);
    }

    @Override
    protected String getSourceType() {
        return "POSTGRESQL";
    }

    @Override
    public String getExtParams(StreamSourceEntity sourceEntity) {
        PostgreSQLSourceDTO postgreSQLSourceDTO = (PostgreSQLSourceDTO)JsonUtils.parseObject((String)sourceEntity.getExtParams(), PostgreSQLSourceDTO.class);
        if (Objects.nonNull(postgreSQLSourceDTO) && StringUtils.isBlank((CharSequence)postgreSQLSourceDTO.getHostname())) {
            PostgreSQLDataNodeInfo dataNodeInfo = (PostgreSQLDataNodeInfo)this.dataNodeService.get(sourceEntity.getDataNodeName(), "POSTGRESQL");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)postgreSQLSourceDTO, (boolean)true);
            postgreSQLSourceDTO.setHostname(dataNodeInfo.getUrl().split(":")[0]);
            postgreSQLSourceDTO.setPort(Integer.valueOf(dataNodeInfo.getUrl().split(":")[1]));
            postgreSQLSourceDTO.setPassword(dataNodeInfo.getToken());
            return JsonUtils.toJsonString((Object)postgreSQLSourceDTO);
        }
        return sourceEntity.getExtParams();
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        PostgreSQLSourceRequest sourceRequest = (PostgreSQLSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            PostgreSQLSourceDTO dto = PostgreSQLSourceDTO.getFromRequest((PostgreSQLSourceRequest)sourceRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of PostgreSQL SourceDTO failure: %s", e.getMessage()));
        }
    }

    @Override
    public StreamSource getFromEntity(StreamSourceEntity entity) {
        PostgreSQLSource source = new PostgreSQLSource();
        if (entity == null) {
            return source;
        }
        PostgreSQLSourceDTO dto = PostgreSQLSourceDTO.getFromJson((String)entity.getExtParams());
        if (StringUtils.isBlank((CharSequence)dto.getHostname())) {
            if (StringUtils.isBlank((CharSequence)entity.getDataNodeName())) {
                throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "postgreSQl hostname unspecified and data node is blank");
            }
            PostgreSQLDataNodeInfo dataNodeInfo = (PostgreSQLDataNodeInfo)this.dataNodeService.get(entity.getDataNodeName(), "POSTGRESQL");
            CommonBeanUtils.copyProperties((Object)dataNodeInfo, (Object)dto, (boolean)true);
            dto.setHostname(dataNodeInfo.getUrl().split(":")[0]);
            dto.setPort(Integer.valueOf(dataNodeInfo.getUrl().split(":")[1]));
            dto.setPassword(dataNodeInfo.getToken());
        }
        CommonBeanUtils.copyProperties((Object)entity, (Object)source, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)source, (boolean)true);
        List<StreamField> sourceFields = super.getSourceFields(entity.getId());
        source.setFieldList(sourceFields);
        return source;
    }
}

