/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeConvertUtils {
    private static final ZoneId defZoneId = ZoneId.systemDefault();
    public static final String PAT_YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final int LENGTH_YYYYMMDDHHMM = "yyyyMMddHHmm".length();
    private static final DateTimeFormatter sdf4yyyyMMddHHmm = DateTimeFormatter.ofPattern("yyyyMMddHHmm");
    public static final String PAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final int LENGTH_YYYYMMDDHHMMSS = "yyyyMMddHHmmss".length();
    private static final DateTimeFormatter sdf4yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public static String ms2yyyyMMddHHmm(long timestamp) {
        return DateTimeConvertUtils.ms2yyyyMMddHHmm(timestamp, defZoneId);
    }

    public static String ms2yyyyMMddHHmm(long timestamp, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return sdf4yyyyMMddHHmm.format(localDateTime);
    }

    public static long yyyyMMddHHmm2ms(String yyyyMMddHHmm) {
        return DateTimeConvertUtils.yyyyMMddHHmm2ms(yyyyMMddHHmm, defZoneId);
    }

    public static long yyyyMMddHHmm2ms(String yyyyMMddHHmm, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.parse(yyyyMMddHHmm, sdf4yyyyMMddHHmm);
        return LocalDateTime.from(localDateTime).atZone(zoneId).toInstant().toEpochMilli();
    }

    public static String ms2yyyyMMddHHmmss(long timestamp) {
        return DateTimeConvertUtils.ms2yyyyMMddHHmmss(timestamp, defZoneId);
    }

    public static String ms2yyyyMMddHHmmss(long timestamp, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return sdf4yyyyMMddHHmmss.format(localDateTime);
    }

    public static String date2yyyyMMddHHmmss(Date date) {
        return DateTimeConvertUtils.date2yyyyMMddHHmmss(date, defZoneId);
    }

    public static String date2yyyyMMddHHmmss(Date date, ZoneId zoneId) {
        if (date == null) {
            return "";
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.ofInstant(date.toInstant(), zoneId);
            return sdf4yyyyMMddHHmmss.format(localDateTime);
        }
        catch (Throwable ex) {
            return "";
        }
    }

    public static long yyyyMMddHHmmss2ms(String yyyyMMddHHmmss) {
        return DateTimeConvertUtils.yyyyMMddHHmmss2ms(yyyyMMddHHmmss, defZoneId);
    }

    public static long yyyyMMddHHmmss2ms(String yyyyMMddHHmmss, ZoneId zoneId) {
        LocalDateTime localDateTime = LocalDateTime.parse(yyyyMMddHHmmss, sdf4yyyyMMddHHmmss);
        return LocalDateTime.from(localDateTime).atZone(zoneId).toInstant().toEpochMilli();
    }

    public static Date yyyyMMddHHmmss2date(String yyyyMMddHHmmss) {
        return DateTimeConvertUtils.yyyyMMddHHmmss2date(yyyyMMddHHmmss, defZoneId);
    }

    public static Date yyyyMMddHHmmss2date(String yyyyMMddHHmmss, ZoneId zoneId) {
        if (yyyyMMddHHmmss == null) {
            return null;
        }
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(yyyyMMddHHmmss, sdf4yyyyMMddHHmmss);
            return Date.from(localDateTime.atZone(zoneId).toInstant());
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

