/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc;

import java.io.Serializable;
import org.apache.inlong.tubemq.corerpc.exception.StandbyException;
import org.apache.inlong.tubemq.corerpc.utils.MixUtils;

public class ResponseWrapper
implements Serializable {
    private static final long serialVersionUID = -3852197088007144687L;
    private int serialNo;
    private int flagId = 0;
    private int serviceType;
    private int protocolVersion;
    private boolean success = false;
    private int methodId;
    private Object responseData;
    private String errMsg;
    private String stackTrace;

    public ResponseWrapper(int flagId, int serialNo, int serviceType, int locVersion, int methodId, Object responseData) {
        this.serialNo = serialNo;
        this.serviceType = serviceType;
        this.protocolVersion = locVersion;
        this.flagId = flagId;
        this.methodId = methodId;
        this.responseData = responseData;
        this.success = true;
    }

    public ResponseWrapper(int flagId, int serialNo, int serviceType, int rmtVersion, int locVersion, Throwable exception) {
        this.serialNo = serialNo;
        this.flagId = flagId;
        this.serviceType = serviceType;
        this.protocolVersion = locVersion;
        String errorClass = null;
        String error = null;
        if (exception.getCause() != null && exception.getCause() instanceof StandbyException) {
            errorClass = exception.getCause().getClass().getName();
            error = exception.getCause().getMessage();
        } else {
            errorClass = exception.getClass().getName();
            error = exception.getMessage();
        }
        this.errMsg = errorClass = MixUtils.replaceClassNamePrefix(errorClass, true, rmtVersion);
        this.stackTrace = error;
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        if (this.stackTrace == null) {
            this.stackTrace = "";
        }
    }

    public ResponseWrapper(int flagId, int serialNo, int serviceType, int locVersion, String errorMsg, String stackTrace) {
        this.serialNo = serialNo;
        this.flagId = flagId;
        this.serviceType = serviceType;
        this.protocolVersion = locVersion;
        this.errMsg = errorMsg;
        this.stackTrace = stackTrace;
        if (this.errMsg == null) {
            this.errMsg = "";
        }
        if (this.stackTrace == null) {
            this.stackTrace = "";
        }
    }

    public int getFlagId() {
        return this.flagId;
    }

    public void setFlagId(int flagId) {
        this.flagId = flagId;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(int serviceType) {
        this.serviceType = serviceType;
    }

    public int getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(int serialNo) {
        this.serialNo = serialNo;
    }

    public int getMethodId() {
        return this.methodId;
    }

    public void setMethodId(int methodId) {
        this.methodId = methodId;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void getClientProtocolVersion(int clientVersion) {
        this.protocolVersion = clientVersion;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public Object getResponseData() {
        return this.responseData;
    }

    public void setResponseData(Object responseData) {
        this.responseData = responseData;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }
}

