/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpEventInfo;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSender;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStaticManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileStaticManager.class);
    public static final String INLONG_AGENT_SYSTEM = "inlong_agent_system";
    public static final String INLONG_FILE_STATIC = "inlong_agent_file_static";
    protected final Integer CACHE_QUEUE_SIZE = 10000;
    private static FileStaticManager manager = null;
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    protected BlockingQueue<FileStatic> queue = new LinkedBlockingQueue<FileStatic>(this.CACHE_QUEUE_SIZE);

    private FileStaticManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Class<FileStaticManager> clazz = FileStaticManager.class;
        synchronized (FileStaticManager.class) {
            if (manager == null) {
                manager = new FileStaticManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static FileStaticManager getInstance() {
        return manager;
    }

    private void doPutStaticMsg(FileStatic data) {
        data.setAgentIp(this.conf.get("agent.local.ip"));
        data.setTag(this.conf.get("agent.cluster.tag"));
        data.setCluster(this.conf.get("agent.cluster.name"));
        while (!this.queue.offer(data)) {
            LOGGER.error("file static queue is full remove {}", this.queue.poll());
        }
    }

    public static void putStaticMsg(FileStatic data) {
        if (FileStaticManager.getInstance() != null) {
            FileStaticManager.getInstance().doPutStaticMsg(data);
        }
    }

    private void doSendStaticMsg(TcpMsgSender sender) {
        while (!this.queue.isEmpty()) {
            FileStatic data = (FileStatic)this.queue.poll();
            LOGGER.info("file static detail: {}", (Object)data);
            if (sender == null) continue;
            try {
                ProcessResult procResult = new ProcessResult();
                long dataTime = AgentUtils.getCurrentTime();
                byte[] body = data.getFieldsString().getBytes(StandardCharsets.UTF_8);
                if (!sender.sendMessage(new TcpEventInfo(INLONG_AGENT_SYSTEM, INLONG_FILE_STATIC, dataTime, null, body), procResult)) {
                    LOGGER.error("send static failed: ret = {}", (Object)procResult);
                    AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_FAILED, (String)INLONG_AGENT_SYSTEM, (String)INLONG_FILE_STATIC, (long)dataTime, (int)1, (long)body.length);
                    AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_FAILED_REAL_TIME, (String)INLONG_AGENT_SYSTEM, (String)INLONG_FILE_STATIC, (long)dataTime, (int)1, (long)body.length);
                    continue;
                }
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_SUCCESS, (String)INLONG_AGENT_SYSTEM, (String)INLONG_FILE_STATIC, (long)dataTime, (int)1, (long)body.length);
                AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_SEND_SUCCESS_REAL_TIME, (String)INLONG_AGENT_SYSTEM, (String)INLONG_FILE_STATIC, (long)dataTime, (int)1, (long)body.length);
            }
            catch (Throwable ex) {
                LOGGER.error("send static throw exception", ex);
            }
        }
    }

    public static void sendStaticMsg(TcpMsgSender sender) {
        if (FileStaticManager.getInstance() != null) {
            FileStaticManager.getInstance().doSendStaticMsg(sender);
        }
    }

    public static class FileStatic {
        private String agentIp;
        private String tag;
        private String cluster;
        private String taskId;
        private String retry;
        private String contentType;
        private String groupId;
        private String streamId;
        private String dataTime;
        private String fileName;
        private String fileLen;
        private String readBytes;
        private String readLines;
        private String sendLines;

        public String getFieldsString() {
            ArrayList fields = Lists.newArrayList();
            fields.add(this.agentIp);
            fields.add(this.tag);
            fields.add(this.cluster);
            fields.add(this.taskId);
            fields.add(this.retry);
            fields.add(this.contentType);
            fields.add(this.groupId);
            fields.add(this.streamId);
            fields.add(this.dataTime);
            fields.add(this.fileName);
            fields.add(this.fileLen);
            fields.add(this.readBytes);
            fields.add(this.readLines);
            fields.add(this.sendLines);
            return Strings.join((Iterable)fields, (char)',');
        }

        public String getAgentIp() {
            return this.agentIp;
        }

        public String getTag() {
            return this.tag;
        }

        public String getCluster() {
            return this.cluster;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public String getRetry() {
            return this.retry;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getStreamId() {
            return this.streamId;
        }

        public String getDataTime() {
            return this.dataTime;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLen() {
            return this.fileLen;
        }

        public String getReadBytes() {
            return this.readBytes;
        }

        public String getReadLines() {
            return this.readLines;
        }

        public String getSendLines() {
            return this.sendLines;
        }

        public void setAgentIp(String agentIp) {
            this.agentIp = agentIp;
        }

        public void setTag(String tag) {
            this.tag = tag;
        }

        public void setCluster(String cluster) {
            this.cluster = cluster;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setRetry(String retry) {
            this.retry = retry;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public void setDataTime(String dataTime) {
            this.dataTime = dataTime;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setFileLen(String fileLen) {
            this.fileLen = fileLen;
        }

        public void setReadBytes(String readBytes) {
            this.readBytes = readBytes;
        }

        public void setReadLines(String readLines) {
            this.readLines = readLines;
        }

        public void setSendLines(String sendLines) {
            this.sendLines = sendLines;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileStatic)) {
                return false;
            }
            FileStatic other = (FileStatic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$agentIp = this.getAgentIp();
            String other$agentIp = other.getAgentIp();
            if (this$agentIp == null ? other$agentIp != null : !this$agentIp.equals(other$agentIp)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
                return false;
            }
            String this$cluster = this.getCluster();
            String other$cluster = other.getCluster();
            if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            String this$retry = this.getRetry();
            String other$retry = other.getRetry();
            if (this$retry == null ? other$retry != null : !this$retry.equals(other$retry)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$streamId = this.getStreamId();
            String other$streamId = other.getStreamId();
            if (this$streamId == null ? other$streamId != null : !this$streamId.equals(other$streamId)) {
                return false;
            }
            String this$dataTime = this.getDataTime();
            String other$dataTime = other.getDataTime();
            if (this$dataTime == null ? other$dataTime != null : !this$dataTime.equals(other$dataTime)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$fileLen = this.getFileLen();
            String other$fileLen = other.getFileLen();
            if (this$fileLen == null ? other$fileLen != null : !this$fileLen.equals(other$fileLen)) {
                return false;
            }
            String this$readBytes = this.getReadBytes();
            String other$readBytes = other.getReadBytes();
            if (this$readBytes == null ? other$readBytes != null : !this$readBytes.equals(other$readBytes)) {
                return false;
            }
            String this$readLines = this.getReadLines();
            String other$readLines = other.getReadLines();
            if (this$readLines == null ? other$readLines != null : !this$readLines.equals(other$readLines)) {
                return false;
            }
            String this$sendLines = this.getSendLines();
            String other$sendLines = other.getSendLines();
            return !(this$sendLines == null ? other$sendLines != null : !this$sendLines.equals(other$sendLines));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileStatic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $agentIp = this.getAgentIp();
            result = result * 59 + ($agentIp == null ? 43 : $agentIp.hashCode());
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            String $cluster = this.getCluster();
            result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            String $retry = this.getRetry();
            result = result * 59 + ($retry == null ? 43 : $retry.hashCode());
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $streamId = this.getStreamId();
            result = result * 59 + ($streamId == null ? 43 : $streamId.hashCode());
            String $dataTime = this.getDataTime();
            result = result * 59 + ($dataTime == null ? 43 : $dataTime.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $fileLen = this.getFileLen();
            result = result * 59 + ($fileLen == null ? 43 : $fileLen.hashCode());
            String $readBytes = this.getReadBytes();
            result = result * 59 + ($readBytes == null ? 43 : $readBytes.hashCode());
            String $readLines = this.getReadLines();
            result = result * 59 + ($readLines == null ? 43 : $readLines.hashCode());
            String $sendLines = this.getSendLines();
            result = result * 59 + ($sendLines == null ? 43 : $sendLines.hashCode());
            return result;
        }

        public String toString() {
            return "FileStaticManager.FileStatic(agentIp=" + this.getAgentIp() + ", tag=" + this.getTag() + ", cluster=" + this.getCluster() + ", taskId=" + this.getTaskId() + ", retry=" + this.getRetry() + ", contentType=" + this.getContentType() + ", groupId=" + this.getGroupId() + ", streamId=" + this.getStreamId() + ", dataTime=" + this.getDataTime() + ", fileName=" + this.getFileName() + ", fileLen=" + this.getFileLen() + ", readBytes=" + this.getReadBytes() + ", readLines=" + this.getReadLines() + ", sendLines=" + this.getSendLines() + ")";
        }

        public FileStatic(String agentIp, String tag, String cluster, String taskId, String retry, String contentType, String groupId, String streamId, String dataTime, String fileName, String fileLen, String readBytes, String readLines, String sendLines) {
            this.agentIp = agentIp;
            this.tag = tag;
            this.cluster = cluster;
            this.taskId = taskId;
            this.retry = retry;
            this.contentType = contentType;
            this.groupId = groupId;
            this.streamId = streamId;
            this.dataTime = dataTime;
            this.fileName = fileName;
            this.fileLen = fileLen;
            this.readBytes = readBytes;
            this.readLines = readLines;
            this.sendLines = sendLines;
        }

        public FileStatic() {
        }
    }
}

