/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ViewVersion", generator="Immutables")
@Immutable
public final class ImmutableViewVersion
implements ViewVersion {
    private final int versionId;
    private final long timestampMillis;
    private final Map<String, String> summary;
    private final List<ViewRepresentation> representations;
    private final int schemaId;
    private volatile transient long lazyInitBitmap;
    private static final long OPERATION_LAZY_INIT_BIT = 1L;
    private transient String operation;

    private ImmutableViewVersion(int versionId, long timestampMillis, Map<String, String> summary, List<ViewRepresentation> representations, int schemaId) {
        this.versionId = versionId;
        this.timestampMillis = timestampMillis;
        this.summary = summary;
        this.representations = representations;
        this.schemaId = schemaId;
    }

    @Override
    public int versionId() {
        return this.versionId;
    }

    @Override
    public long timestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public Map<String, String> summary() {
        return this.summary;
    }

    @Override
    public List<ViewRepresentation> representations() {
        return this.representations;
    }

    @Override
    public int schemaId() {
        return this.schemaId;
    }

    public final ImmutableViewVersion withVersionId(int value) {
        if (this.versionId == value) {
            return this;
        }
        return ImmutableViewVersion.validate(new ImmutableViewVersion(value, this.timestampMillis, this.summary, this.representations, this.schemaId));
    }

    public final ImmutableViewVersion withTimestampMillis(long value) {
        if (this.timestampMillis == value) {
            return this;
        }
        return ImmutableViewVersion.validate(new ImmutableViewVersion(this.versionId, value, this.summary, this.representations, this.schemaId));
    }

    public final ImmutableViewVersion withSummary(Map<String, ? extends String> entries) {
        if (this.summary == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableViewVersion.createUnmodifiableMap(true, false, entries);
        return ImmutableViewVersion.validate(new ImmutableViewVersion(this.versionId, this.timestampMillis, newValue, this.representations, this.schemaId));
    }

    public final ImmutableViewVersion withRepresentations(ViewRepresentation ... elements) {
        List<ViewRepresentation> newValue = ImmutableViewVersion.createUnmodifiableList(false, ImmutableViewVersion.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableViewVersion.validate(new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, newValue, this.schemaId));
    }

    public final ImmutableViewVersion withRepresentations(Iterable<? extends ViewRepresentation> elements) {
        if (this.representations == elements) {
            return this;
        }
        List<ViewRepresentation> newValue = ImmutableViewVersion.createUnmodifiableList(false, ImmutableViewVersion.createSafeList(elements, true, false));
        return ImmutableViewVersion.validate(new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, newValue, this.schemaId));
    }

    public final ImmutableViewVersion withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return ImmutableViewVersion.validate(new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, this.representations, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewVersion && this.equalTo(0, (ImmutableViewVersion)another);
    }

    private boolean equalTo(int synthetic, ImmutableViewVersion another) {
        return this.versionId == another.versionId && this.timestampMillis == another.timestampMillis && this.summary.equals(another.summary) && this.representations.equals(another.representations) && this.schemaId == another.schemaId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.versionId;
        h += (h << 5) + Long.hashCode(this.timestampMillis);
        h += (h << 5) + this.summary.hashCode();
        h += (h << 5) + this.representations.hashCode();
        h += (h << 5) + this.schemaId;
        return h;
    }

    public String toString() {
        return "ViewVersion{versionId=" + this.versionId + ", timestampMillis=" + this.timestampMillis + ", summary=" + this.summary + ", representations=" + this.representations + ", schemaId=" + this.schemaId + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String operation() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableViewVersion immutableViewVersion = this;
            synchronized (immutableViewVersion) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.operation = Objects.requireNonNull(ViewVersion.super.operation(), "operation");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.operation;
    }

    private static ImmutableViewVersion validate(ImmutableViewVersion instance) {
        instance.check();
        return instance;
    }

    public static ImmutableViewVersion copyOf(ViewVersion instance) {
        if (instance instanceof ImmutableViewVersion) {
            return (ImmutableViewVersion)instance;
        }
        return ImmutableViewVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ViewVersion", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION_ID = 1L;
        private static final long INIT_BIT_TIMESTAMP_MILLIS = 2L;
        private static final long INIT_BIT_SCHEMA_ID = 4L;
        private long initBits = 7L;
        private int versionId;
        private long timestampMillis;
        private Map<String, String> summary = new LinkedHashMap<String, String>();
        private List<ViewRepresentation> representations = new ArrayList<ViewRepresentation>();
        private int schemaId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ViewVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.versionId(instance.versionId());
            this.timestampMillis(instance.timestampMillis());
            this.putAllSummary(instance.summary());
            this.addAllRepresentations(instance.representations());
            this.schemaId(instance.schemaId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder versionId(int versionId) {
            this.versionId = versionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestampMillis(long timestampMillis) {
            this.timestampMillis = timestampMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSummary(String key, String value) {
            this.summary.put(Objects.requireNonNull(key, "summary key"), value == null ? Objects.requireNonNull(value, "summary value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSummary(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.summary.put(Objects.requireNonNull(k, "summary key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "summary value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder summary(Map<String, ? extends String> entries) {
            this.summary.clear();
            return this.putAllSummary(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSummary(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.summary.put(Objects.requireNonNull(k, "summary key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "summary value for key: " + k) : v);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepresentations(ViewRepresentation element) {
            this.representations.add(Objects.requireNonNull(element, "representations element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepresentations(ViewRepresentation ... elements) {
            for (ViewRepresentation element : elements) {
                this.representations.add(Objects.requireNonNull(element, "representations element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder representations(Iterable<? extends ViewRepresentation> elements) {
            this.representations.clear();
            return this.addAllRepresentations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRepresentations(Iterable<? extends ViewRepresentation> elements) {
            for (ViewRepresentation viewRepresentation : elements) {
                this.representations.add(Objects.requireNonNull(viewRepresentation, "representations element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableViewVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableViewVersion.validate(new ImmutableViewVersion(this.versionId, this.timestampMillis, ImmutableViewVersion.createUnmodifiableMap(false, false, this.summary), ImmutableViewVersion.createUnmodifiableList(true, this.representations), this.schemaId));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("versionId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timestampMillis");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaId");
            }
            return "Cannot build ViewVersion, some of required attributes are not set " + attributes;
        }
    }
}

