/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.region;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.region.request.CreateRegionReq;
import org.apache.inlong.tubemq.manager.controller.region.request.DeleteRegionReq;
import org.apache.inlong.tubemq.manager.controller.region.request.ModifyRegionReq;
import org.apache.inlong.tubemq.manager.controller.region.request.QueryRegionReq;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.entry.RegionEntry;
import org.apache.inlong.tubemq.manager.service.interfaces.ClusterService;
import org.apache.inlong.tubemq.manager.service.interfaces.RegionService;
import org.apache.inlong.tubemq.manager.utils.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/region"})
public class RegionController {
    private static final Logger log = LoggerFactory.getLogger(RegionController.class);
    private final Gson gson = new GsonBuilder().serializeNulls().create();
    @Autowired
    RegionService regionService;
    @Autowired
    ClusterService clusterService;

    @RequestMapping(value={""})
    @ResponseBody
    public TubeMQResult brokerMethodProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "add": {
                return this.createNewRegion((CreateRegionReq)this.gson.fromJson(req, CreateRegionReq.class));
            }
            case "delete": {
                return this.deleteRegion((DeleteRegionReq)this.gson.fromJson(req, DeleteRegionReq.class));
            }
            case "modify": {
                return this.modifyRegion((ModifyRegionReq)this.gson.fromJson(req, ModifyRegionReq.class));
            }
            case "query": {
                return this.queryRegion((QueryRegionReq)this.gson.fromJson(req, QueryRegionReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    private TubeMQResult queryRegion(QueryRegionReq req) {
        if (ValidateUtils.isNull(req.getClusterId())) {
            return TubeMQResult.errorResult("param illegal");
        }
        List<RegionEntry> regionEntries = this.regionService.queryRegion(req.getRegionId(), req.getClusterId());
        return TubeMQResult.successResult(regionEntries);
    }

    private TubeMQResult deleteRegion(DeleteRegionReq req) {
        return this.regionService.deleteRegion(req.getRegionId(), req.getClusterId());
    }

    private TubeMQResult createNewRegion(CreateRegionReq req) {
        RegionEntry regionEntry = req.getRegionEntry();
        if (ValidateUtils.isNull(regionEntry) || !regionEntry.legal() || ValidateUtils.isNull(req.getBrokerIdSet())) {
            return TubeMQResult.errorResult("param illegal");
        }
        ClusterEntry clusterEntry = this.clusterService.getOneCluster(req.getClusterId());
        if (clusterEntry == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        ArrayList<Long> brokerList = new ArrayList<Long>(req.getBrokerIdSet());
        return this.regionService.createNewRegion(regionEntry, brokerList);
    }

    private TubeMQResult modifyRegion(ModifyRegionReq req) {
        RegionEntry regionEntry = req.getRegionEntry();
        if (!regionEntry.legal() || ValidateUtils.isNull(regionEntry.getClusterId())) {
            return TubeMQResult.errorResult("param illegal");
        }
        ArrayList<Long> brokerList = new ArrayList<Long>(req.getBrokerIdSet());
        return this.regionService.updateRegion(req.getRegionEntry(), brokerList, req.getClusterId());
    }
}

