/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.entry.TopicStatus;
import org.apache.inlong.tubemq.manager.entry.TopicTaskEntry;
import org.apache.inlong.tubemq.manager.enums.ErrorCode;
import org.apache.inlong.tubemq.manager.enums.TaskStatusEnum;
import org.apache.inlong.tubemq.manager.executors.AddTopicExecutor;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.repository.TopicTaskRepository;
import org.apache.inlong.tubemq.manager.service.interfaces.ClusterService;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.interfaces.NodeService;
import org.apache.inlong.tubemq.manager.service.interfaces.TaskService;
import org.apache.inlong.tubemq.manager.service.interfaces.TopicService;
import org.apache.inlong.tubemq.manager.service.tube.TopicView;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpBrokerInfoList;
import org.apache.inlong.tubemq.manager.utils.ValidateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    public static final Integer MAX_RELOAD_TIMES = 500;
    @Autowired
    TopicTaskRepository topicTaskRepository;
    @Autowired
    ClusterService clusterService;
    @Autowired
    AddTopicExecutor addTopicExecutor;
    @Autowired
    NodeService nodeService;
    @Autowired
    MasterRepository masterRepository;
    @Autowired
    TopicService topicService;
    @Autowired
    MasterService masterService;

    @Override
    @Transactional
    public TubeMQResult addTopicCreateTask(Long clusterId, Set<String> topicNames) {
        try {
            ArrayList topicTaskEntries = new ArrayList(64);
            Set<String> existTopicNames = this.findExistTopics(clusterId, topicNames);
            if (!existTopicNames.isEmpty()) {
                return TubeMQResult.errorResult("There are topic tasks " + existTopicNames + " already in adding status", ErrorCode.TASK_EXIST.getCode());
            }
            topicNames.forEach(topicName -> {
                TopicTaskEntry entry = new TopicTaskEntry();
                entry.setClusterId(clusterId);
                entry.setTopicName((String)topicName);
                topicTaskEntries.add(entry);
            });
            this.topicTaskRepository.saveAll(topicTaskEntries);
        }
        catch (Exception e) {
            log.error("save topic tasks to db fail, topics : {}", topicNames, (Object)e);
            return TubeMQResult.errorResult("mysql error");
        }
        return TubeMQResult.successResult();
    }

    private Set<String> findExistTopics(Long clusterId, Set<String> topicNames) {
        Set<String> existTopicName = topicNames.stream().filter(topicName -> this.hasAlreadyExistTopicTask(clusterId, (String)topicName, TaskStatusEnum.ADDING.getCode())).collect(Collectors.toSet());
        return existTopicName;
    }

    public boolean hasAlreadyExistTopicTask(Long clusterId, String topicName, Integer status) {
        TopicTaskEntry taskEntry = this.topicTaskRepository.findTopicTaskEntryByClusterIdAndStatusAndTopicName(clusterId, status, topicName);
        return taskEntry != null;
    }

    @Scheduled(cron="${topic.config.schedule}")
    public void executeTopicConfigTasks() {
        List<ClusterEntry> allClusters = this.clusterService.getAllClusters();
        for (ClusterEntry cluster : allClusters) {
            long clusterId = cluster.getClusterId();
            List<TopicTaskEntry> topicTasks = this.topicTaskRepository.findTopicTaskEntriesByClusterIdAndStatus(clusterId, TaskStatusEnum.ADDING.getCode());
            this.addTopicExecutor.addTopicConfig(clusterId, topicTasks);
        }
    }

    @Scheduled(cron="${broker.reload.schedule}")
    public void reloadBrokers() {
        List<ClusterEntry> allClusters = this.clusterService.getAllClusters();
        for (ClusterEntry cluster : allClusters) {
            TubeHttpBrokerInfoList brokerInfoList;
            long clusterId = cluster.getClusterId();
            MasterEntry masterEntry = this.masterService.getMasterNode(clusterId);
            if (ValidateUtils.isNull(masterEntry) || ValidateUtils.isNull(brokerInfoList = this.nodeService.requestBrokerStatus(masterEntry))) continue;
            this.doReloadBrokers(clusterId, masterEntry, brokerInfoList, cluster);
        }
    }

    @Async(value="asyncExecutor")
    public void doReloadBrokers(long clusterId, MasterEntry masterEntry, TubeHttpBrokerInfoList brokerInfoList, ClusterEntry clusterEntry) {
        this.nodeService.handleReloadBroker(masterEntry, brokerInfoList.getNeedReloadList(), clusterEntry);
        this.updateCreateTopicTaskStatus(clusterId);
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateCreateTopicTaskStatus(long clusterId) {
        List<TopicTaskEntry> topicTasks = this.topicTaskRepository.findTopicTaskEntriesByClusterIdAndStatus(clusterId, TaskStatusEnum.ADDING.getCode());
        TopicView topicView = this.topicService.requestTopicViewInfo(clusterId, null);
        if (topicView == null || topicView.getData() == null) {
            return;
        }
        List<TopicView.TopicViewInfo> topicViews = topicView.getData();
        Map<String, TopicView.TopicViewInfo> topicViewMap = topicViews.stream().collect(Collectors.toMap(TopicView.TopicViewInfo::getTopicName, topicViewInfo -> topicViewInfo));
        MasterEntry masterNode = this.masterService.getMasterNode(clusterId);
        TubeHttpBrokerInfoList brokerInfoList = this.nodeService.requestBrokerStatus(masterNode);
        if (ValidateUtils.isNull(brokerInfoList)) {
            return;
        }
        this.updateTaskRepo(topicTasks, topicViewMap, brokerInfoList);
    }

    private void updateTaskRepo(List<TopicTaskEntry> topicTasks, Map<String, TopicView.TopicViewInfo> topicViewMap, TubeHttpBrokerInfoList brokerInfoList) {
        int size = brokerInfoList.getAllBrokerIdList().size();
        for (TopicTaskEntry topicTask : topicTasks) {
            TopicView.TopicViewInfo topicViewInfo = topicViewMap.get(topicTask.getTopicName());
            if (topicViewInfo == null) continue;
            if (size == topicViewInfo.getTotalCfgBrokerCnt() && topicViewInfo.getTotalCfgNumPart() == topicViewInfo.getTotalRunNumPartCount()) {
                topicTask.setStatus(TaskStatusEnum.SUCCESS.getCode());
                continue;
            }
            Integer reloadRetryTimes = topicTask.getReloadRetryTimes();
            if (reloadRetryTimes >= MAX_RELOAD_TIMES) {
                topicTask.setStatus(TopicStatus.FAILED.value());
            }
            topicTask.setReloadRetryTimes(reloadRetryTimes + 1);
        }
        this.topicTaskRepository.saveAll(topicTasks);
    }
}

