/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.utils;

import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.tubemq.manager.controller.cluster.vo.ClusterVo;
import org.apache.inlong.tubemq.manager.controller.topic.request.RebalanceConsumerReq;
import org.apache.inlong.tubemq.manager.controller.topic.request.RebalanceGroupReq;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(ConvertUtils.class);
    private static final Gson gson = new Gson();

    public static String convertReqToQueryStr(Object req) {
        ArrayList<String> queryList = new ArrayList<String>();
        try {
            List<Field[]> fieldsList = ConvertUtils.getAllFileds(req);
            ConvertUtils.getQueryFields(req, queryList, fieldsList);
        }
        catch (Exception e) {
            log.error("exception occurred while parsing object {}", (Object)gson.toJson(req), (Object)e);
            return "";
        }
        return StringUtils.join(queryList, (String)"&");
    }

    private static void getQueryFields(Object req, List<String> queryList, List<Field[]> fieldsList) throws IllegalAccessException, UnsupportedEncodingException {
        Iterator<Field[]> iterator = fieldsList.iterator();
        while (iterator.hasNext()) {
            Field[] fields;
            Field[] f;
            for (Field field : f = (fields = iterator.next())) {
                field.setAccessible(true);
                Object o = field.get(req);
                if (o == null) continue;
                String value = o instanceof List ? gson.toJson(o) : o.toString();
                queryList.add(field.getName() + "=" + URLEncoder.encode(value, StandardCharsets.UTF_8.toString()));
            }
        }
    }

    private static List<Field[]> getAllFileds(Object req) throws ClassNotFoundException {
        Class clz = ClassUtils.getClass((String)ClassUtils.getName((Object)req));
        Field[] declaredFields = clz.getDeclaredFields();
        ArrayList<Field[]> fieldsList = new ArrayList<Field[]>();
        fieldsList.add(declaredFields);
        List allSuperclasses = ClassUtils.getAllSuperclasses((Class)clz);
        allSuperclasses.forEach(clazz -> fieldsList.add(clazz.getDeclaredFields()));
        return fieldsList;
    }

    public static RebalanceConsumerReq convertToRebalanceConsumerReq(RebalanceGroupReq req, String consumerId) {
        RebalanceConsumerReq consumerReq = new RebalanceConsumerReq();
        consumerReq.setConsumerId(consumerId);
        consumerReq.setConfModAuthToken(req.getConfModAuthToken());
        consumerReq.setGroupName(req.getGroupName());
        consumerReq.setModifyUser(req.getModifyUser());
        consumerReq.setReJoinWait(req.getReJoinWait());
        consumerReq.setType("op_modify");
        consumerReq.setMethod("admin_rebalance_group_allocate");
        return consumerReq;
    }

    public static String covertMapToQueryString(Map<String, String> requestMap) throws Exception {
        ArrayList<String> queryList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : requestMap.entrySet()) {
            queryList.add(entry.getKey() + "=" + URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString()));
        }
        return StringUtils.join(queryList, (String)"&");
    }

    public static ClusterVo convertToClusterVo(ClusterEntry clusterEntry, List<MasterEntry> masterEntries, ClusterVo clusterVo) {
        ClusterVo cluster = new ClusterVo();
        cluster.setClusterId(clusterEntry.getClusterId());
        cluster.setMasterEntries(masterEntries);
        cluster.setClusterName(clusterEntry.getClusterName());
        cluster.setReloadBrokerSize(clusterEntry.getReloadBrokerSize());
        cluster.setBrokerCount(clusterVo.getBrokerCount());
        cluster.setTopicCount(clusterVo.getTopicCount());
        cluster.setPartitionCount(clusterVo.getPartitionCount());
        cluster.setConsumerGroupCount(clusterVo.getConsumerGroupCount());
        cluster.setConsumerCount(clusterVo.getConsumerCount());
        cluster.setStoreCount(clusterVo.getStoreCount());
        return cluster;
    }
}

