/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.audit;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.enums.NotifyType;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.apache.inlong.manager.pojo.audit.AuditAlertCondition;

@ApiModel(value="Audit Alert Rule Request")
public class AuditAlertRuleRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateValidation.class}, message="Rule ID cannot be null for update")
    private @NotNull(groups={UpdateValidation.class}, message="Rule ID cannot be null for update") Integer id;
    @ApiModelProperty(value="Associated InLong Group ID", required=true)
    @NotBlank(message="InLong Group ID cannot be blank")
    private @NotBlank(message="InLong Group ID cannot be blank") String inlongGroupId;
    @ApiModelProperty(value="Associated InLong Stream ID")
    private String inlongStreamId;
    @ApiModelProperty(value="Audit ID (associated with specific audit metrics, such as send success count, delay, etc.)", required=true)
    @NotBlank(message="Audit ID cannot be blank")
    private @NotBlank(message="Audit ID cannot be blank") String auditId;
    @ApiModelProperty(value="Alert name", required=true)
    @NotBlank(message="Alert name cannot be blank")
    private @NotBlank(message="Alert name cannot be blank") String alertName;
    @ApiModelProperty(value="Trigger condition", required=true)
    @NotNull(message="Trigger condition cannot be null")
    private @NotNull(message="Trigger condition cannot be null") AuditAlertCondition condition;
    @ApiModelProperty(value="Alert level (INFO/WARN/ERROR/CRITICAL)")
    @Pattern(regexp="^(INFO|WARN|ERROR|CRITICAL)$", message="Alert level must be one of INFO, WARN, ERROR, or CRITICAL")
    private @Pattern(regexp="^(INFO|WARN|ERROR|CRITICAL)$", message="Alert level must be one of INFO, WARN, ERROR, or CRITICAL") String level;
    @ApiModelProperty(value="Notification type (EMAIL/SMS/HTTP)")
    private NotifyType notifyType;
    @ApiModelProperty(value="Notification recipients (separated by commas for multiple recipients)")
    private String receivers;
    @ApiModelProperty(value="Whether enabled", required=true)
    @NotNull(message="Enabled status cannot be null")
    private @NotNull(message="Enabled status cannot be null") Boolean enabled;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateValidation.class}, message="Version cannot be null for update")
    private @NotNull(groups={UpdateValidation.class}, message="Version cannot be null for update") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getAuditId() {
        return this.auditId;
    }

    public String getAlertName() {
        return this.alertName;
    }

    public AuditAlertCondition getCondition() {
        return this.condition;
    }

    public String getLevel() {
        return this.level;
    }

    public NotifyType getNotifyType() {
        return this.notifyType;
    }

    public String getReceivers() {
        return this.receivers;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setInlongStreamId(String inlongStreamId) {
        this.inlongStreamId = inlongStreamId;
    }

    public void setAuditId(String auditId) {
        this.auditId = auditId;
    }

    public void setAlertName(String alertName) {
        this.alertName = alertName;
    }

    public void setCondition(AuditAlertCondition condition) {
        this.condition = condition;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setNotifyType(NotifyType notifyType) {
        this.notifyType = notifyType;
    }

    public void setReceivers(String receivers) {
        this.receivers = receivers;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditAlertRuleRequest)) {
            return false;
        }
        AuditAlertRuleRequest other = (AuditAlertRuleRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$inlongStreamId = this.getInlongStreamId();
        String other$inlongStreamId = other.getInlongStreamId();
        if (this$inlongStreamId == null ? other$inlongStreamId != null : !this$inlongStreamId.equals(other$inlongStreamId)) {
            return false;
        }
        String this$auditId = this.getAuditId();
        String other$auditId = other.getAuditId();
        if (this$auditId == null ? other$auditId != null : !this$auditId.equals(other$auditId)) {
            return false;
        }
        String this$alertName = this.getAlertName();
        String other$alertName = other.getAlertName();
        if (this$alertName == null ? other$alertName != null : !this$alertName.equals(other$alertName)) {
            return false;
        }
        AuditAlertCondition this$condition = this.getCondition();
        AuditAlertCondition other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !((Object)this$condition).equals(other$condition)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        NotifyType this$notifyType = this.getNotifyType();
        NotifyType other$notifyType = other.getNotifyType();
        if (this$notifyType == null ? other$notifyType != null : !this$notifyType.equals(other$notifyType)) {
            return false;
        }
        String this$receivers = this.getReceivers();
        String other$receivers = other.getReceivers();
        return !(this$receivers == null ? other$receivers != null : !this$receivers.equals(other$receivers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuditAlertRuleRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $inlongStreamId = this.getInlongStreamId();
        result = result * 59 + ($inlongStreamId == null ? 43 : $inlongStreamId.hashCode());
        String $auditId = this.getAuditId();
        result = result * 59 + ($auditId == null ? 43 : $auditId.hashCode());
        String $alertName = this.getAlertName();
        result = result * 59 + ($alertName == null ? 43 : $alertName.hashCode());
        AuditAlertCondition $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : ((Object)$condition).hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        NotifyType $notifyType = this.getNotifyType();
        result = result * 59 + ($notifyType == null ? 43 : $notifyType.hashCode());
        String $receivers = this.getReceivers();
        result = result * 59 + ($receivers == null ? 43 : $receivers.hashCode());
        return result;
    }

    public String toString() {
        return "AuditAlertRuleRequest(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", inlongStreamId=" + this.getInlongStreamId() + ", auditId=" + this.getAuditId() + ", alertName=" + this.getAlertName() + ", condition=" + this.getCondition() + ", level=" + this.getLevel() + ", notifyType=" + this.getNotifyType() + ", receivers=" + this.getReceivers() + ", enabled=" + this.getEnabled() + ", version=" + this.getVersion() + ")";
    }
}

