/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hudi;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;

public enum HudiPartition {
    IDENTITY,
    BUCKET,
    TRUNCATE,
    YEAR,
    MONTH,
    DAY,
    HOUR,
    NONE;


    public static HudiPartition forName(String name) {
        Preconditions.expectNotBlank((String)name, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"HudiPartition should not be null");
        for (HudiPartition value : HudiPartition.values()) {
            if (!value.toString().equalsIgnoreCase(name)) continue;
            return value;
        }
        throw new IllegalArgumentException(String.format("Unsupported HudiPartition : %s", name));
    }

    public String toString() {
        return this.name();
    }
}

