/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hudi;

public enum HudiType {
    BOOLEAN("boolean", "boolean"),
    INT("int", "int"),
    LONG("long", "bigint"),
    FLOAT("float", "float"),
    DOUBLE("double", "double"),
    DATE("date", "date"),
    TIME("time", "time(0)"),
    TIMESTAMP("timestamp", "timestamp(3)"),
    TIMESTAMPT_Z("timestamptz", "timestamp(6)"),
    STRING("string", "varchar(2147483647)"),
    BINARY("binary", "tinyint"),
    UUID("uuid", "uuid"),
    FIXED("fixed", null),
    DECIMAL("decimal", null);

    private final String type;
    private final String hiveType;

    private HudiType(String type, String hiveType) {
        this.type = type;
        this.hiveType = hiveType;
    }

    public static HudiType forType(String type) {
        for (HudiType ibType : HudiType.values()) {
            if (!ibType.getType().equalsIgnoreCase(type)) continue;
            return ibType;
        }
        throw new IllegalArgumentException(String.format("invalid hudi type = %s", type));
    }

    public String getType() {
        return this.type;
    }

    public String getHiveType() {
        return this.hiveType;
    }
}

