/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.starrocks;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;

@ApiModel(value="StarRocks sink request")
@JsonTypeDefine(value="STARROCKS")
public class StarRocksSinkRequest
extends SinkRequest {
    @ApiModelProperty(value="StarRocks jdbc url")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String jdbcUrl;
    @ApiModelProperty(value="StarRocks FE http address")
    private String loadUrl;
    @ApiModelProperty(value="Username for StarRocks accessing")
    private String username;
    @ApiModelProperty(value="Password for StarRocks accessing")
    private String password;
    @ApiModelProperty(value="Database name")
    private String databaseName;
    @ApiModelProperty(value="Table name")
    private String tableName;
    @ApiModelProperty(value="The primary key of sink table")
    private String primaryKey;
    @ApiModelProperty(value="The multiple enable of sink")
    private Boolean sinkMultipleEnable = false;
    @ApiModelProperty(value="The multiple format of sink")
    private String sinkMultipleFormat;
    @ApiModelProperty(value="The multiple database-pattern of sink")
    private String databasePattern;
    @ApiModelProperty(value="The multiple table-pattern of sink")
    private String tablePattern;
    @ApiModelProperty(value="The table engine,  like: OLAP, MYSQL, ELASTICSEARCH, etc, default is OLAP")
    private String tableEngine = "OLAP";
    @ApiModelProperty(value="The table replication num")
    private Integer replicationNum = 3;
    @ApiModelProperty(value="The table barrel size")
    private Integer barrelSize = 8;

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getLoadUrl() {
        return this.loadUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    public String getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public String getTableEngine() {
        return this.tableEngine;
    }

    public Integer getReplicationNum() {
        return this.replicationNum;
    }

    public Integer getBarrelSize() {
        return this.barrelSize;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setLoadUrl(String loadUrl) {
        this.loadUrl = loadUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setSinkMultipleEnable(Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setTableEngine(String tableEngine) {
        this.tableEngine = tableEngine;
    }

    public void setReplicationNum(Integer replicationNum) {
        this.replicationNum = replicationNum;
    }

    public void setBarrelSize(Integer barrelSize) {
        this.barrelSize = barrelSize;
    }

    @Override
    public String toString() {
        return "StarRocksSinkRequest(super=" + super.toString() + ", jdbcUrl=" + this.getJdbcUrl() + ", loadUrl=" + this.getLoadUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", tableEngine=" + this.getTableEngine() + ", replicationNum=" + this.getReplicationNum() + ", barrelSize=" + this.getBarrelSize() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarRocksSinkRequest)) {
            return false;
        }
        StarRocksSinkRequest other = (StarRocksSinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        Integer this$replicationNum = this.getReplicationNum();
        Integer other$replicationNum = other.getReplicationNum();
        if (this$replicationNum == null ? other$replicationNum != null : !((Object)this$replicationNum).equals(other$replicationNum)) {
            return false;
        }
        Integer this$barrelSize = this.getBarrelSize();
        Integer other$barrelSize = other.getBarrelSize();
        if (this$barrelSize == null ? other$barrelSize != null : !((Object)this$barrelSize).equals(other$barrelSize)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$loadUrl = this.getLoadUrl();
        String other$loadUrl = other.getLoadUrl();
        if (this$loadUrl == null ? other$loadUrl != null : !this$loadUrl.equals(other$loadUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$sinkMultipleFormat = this.getSinkMultipleFormat();
        String other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        String this$tableEngine = this.getTableEngine();
        String other$tableEngine = other.getTableEngine();
        return !(this$tableEngine == null ? other$tableEngine != null : !this$tableEngine.equals(other$tableEngine));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StarRocksSinkRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        Integer $replicationNum = this.getReplicationNum();
        result = result * 59 + ($replicationNum == null ? 43 : ((Object)$replicationNum).hashCode());
        Integer $barrelSize = this.getBarrelSize();
        result = result * 59 + ($barrelSize == null ? 43 : ((Object)$barrelSize).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $loadUrl = this.getLoadUrl();
        result = result * 59 + ($loadUrl == null ? 43 : $loadUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        String $tableEngine = this.getTableEngine();
        result = result * 59 + ($tableEngine == null ? 43 : $tableEngine.hashCode());
        return result;
    }
}

