/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeStrategyFactory;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseSink;
import org.apache.inlong.manager.pojo.sink.oceanbase.OceanBaseSinkDTO;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.OceanBaseLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OceanBaseProvider
implements LoadNodeProvider {
    @Autowired
    private FieldTypeStrategyFactory fieldTypeStrategyFactory;

    @Override
    public Boolean accept(String sinkType) {
        return "OCEANBASE".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        OceanBaseSink oceanBaseSink = (OceanBaseSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(oceanBaseSink.getProperties());
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance("MYSQL");
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(oceanBaseSink.getSinkFieldList(), oceanBaseSink.getSinkName(), fieldTypeMappingStrategy);
        List<FieldRelation> fieldRelations = this.parseSinkFields(oceanBaseSink.getSinkFieldList(), constantFieldMap);
        return new OceanBaseLoadNode(oceanBaseSink.getSinkName(), oceanBaseSink.getSinkName(), fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, null, properties, OceanBaseSinkDTO.setDbNameToUrlWithCdc(oceanBaseSink.getJdbcUrl(), oceanBaseSink.getDatabaseName()), oceanBaseSink.getUsername(), oceanBaseSink.getPassword(), oceanBaseSink.getTableName(), oceanBaseSink.getPrimaryKey());
    }
}

