/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.stream;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.inlong.manager.common.validation.SaveValidation;
import org.apache.inlong.manager.common.validation.UpdateValidation;
import org.hibernate.validator.constraints.Length;

@ApiModel(value="Tenant template tag request")
public class TenantTemplateRequest {
    @ApiModelProperty(value="Primary key")
    @NotNull(groups={UpdateValidation.class}, message="id cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="id cannot be null") Integer id;
    @ApiModelProperty(value="Template name")
    private String templateName;
    @ApiModelProperty(value="Inlong tenant which template")
    @NotBlank(groups={SaveValidation.class}, message="tenant cannot be blank")
    @Length(min=1, max=256, message="length must be between 1 and 256")
    private @NotBlank(groups={SaveValidation.class}, message="tenant cannot be blank") @Length(min=1, max=256, message="length must be between 1 and 256") String tenant;
    @ApiModelProperty(value="Version number")
    @NotNull(groups={UpdateValidation.class}, message="version cannot be null")
    private @NotNull(groups={UpdateValidation.class}, message="version cannot be null") Integer version;

    public Integer getId() {
        return this.id;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTenant() {
        return this.tenant;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantTemplateRequest)) {
            return false;
        }
        TenantTemplateRequest other = (TenantTemplateRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$templateName = this.getTemplateName();
        String other$templateName = other.getTemplateName();
        if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantTemplateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $templateName = this.getTemplateName();
        result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    public String toString() {
        return "TenantTemplateRequest(id=" + this.getId() + ", templateName=" + this.getTemplateName() + ", tenant=" + this.getTenant() + ", version=" + this.getVersion() + ")";
    }
}

