/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.remote;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.inlong.common.enums.DataProxyErrCode;
import org.apache.inlong.dataproxy.config.remote.RequestContent;
import org.apache.inlong.dataproxy.config.remote.ResponseResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMessageServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigMessageServlet.class);
    private final Gson gson = new Gson();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPost(req, resp);
    }

    private void responseToJson(HttpServletResponse response, ResponseResult result) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        String jsonStr = this.gson.toJson((Object)result);
        PrintWriter out = response.getWriter();
        out.print(jsonStr);
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ResponseResult result = new ResponseResult(DataProxyErrCode.UNKNOWN_ERROR.getErrCode(), "");
        try (BufferedReader reader = null;){
            reader = req.getReader();
            RequestContent requestContent = (RequestContent)this.gson.fromJson(IOUtils.toString((Reader)reader), RequestContent.class);
            if (requestContent.getRequestType() != null && requestContent.getOperationType() != null) {
                result.setMessage("Unsupported operation");
            } else {
                result.setMessage("request format is not valid");
            }
        }
        this.responseToJson(resp, result);
    }
}

