/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.MapSpecification;
import springfox.documentation.schema.ModelFacets;
import springfox.documentation.schema.ModelKey;
import springfox.documentation.schema.ReferenceModelSpecification;
import springfox.documentation.schema.ScalarModelSpecification;
import springfox.documentation.service.VendorExtension;

public class ModelSpecification {
    private final ScalarModelSpecification scalar;
    private final CompoundModelSpecification compound;
    private final CollectionSpecification collection;
    private final MapSpecification map;
    private final ReferenceModelSpecification reference;
    private final ModelFacets facets;
    private final String name;

    public ModelSpecification(String name, ModelFacets facets, ScalarModelSpecification scalar, CompoundModelSpecification compound, CollectionSpecification collection, MapSpecification map, ReferenceModelSpecification reference) {
        this.name = name;
        this.collection = collection;
        this.facets = facets;
        this.map = map;
        this.scalar = scalar;
        this.compound = compound;
        this.reference = reference;
    }

    public Optional<ModelKey> key() {
        return this.getCompound().map(CompoundModelSpecification::getModelKey);
    }

    public Optional<ScalarModelSpecification> getScalar() {
        return Optional.ofNullable(this.scalar);
    }

    public Optional<CompoundModelSpecification> getCompound() {
        return Optional.ofNullable(this.compound);
    }

    public Optional<CollectionSpecification> getCollection() {
        return Optional.ofNullable(this.collection);
    }

    public Optional<MapSpecification> getMap() {
        return Optional.ofNullable(this.map);
    }

    public Optional<ReferenceModelSpecification> getReference() {
        return Optional.ofNullable(this.reference);
    }

    public Optional<ModelFacets> getFacets() {
        return Optional.ofNullable(this.facets);
    }

    public List<Example> getFacetExamples() {
        return this.getFacets().map(ModelFacets::getExamples).orElse(Collections.EMPTY_LIST);
    }

    public List<VendorExtension> getFacetExtensions() {
        return this.getFacets().map(ModelFacets::getExtensions).orElse(Collections.EMPTY_LIST);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelSpecification that = (ModelSpecification)o;
        return Objects.equals(this.scalar, that.scalar) && Objects.equals(this.compound, that.compound) && Objects.equals(this.collection, that.collection) && Objects.equals(this.map, that.map) && Objects.equals(this.reference, that.reference) && Objects.equals(this.facets, that.facets) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.scalar, this.compound, this.collection, this.map, this.reference, this.facets, this.name);
    }

    public String toString() {
        return new StringJoiner(", ", ModelSpecification.class.getSimpleName() + "[", "]").add("scalar=" + this.scalar).add("compound=" + this.compound).add("collection=" + this.collection).add("map=" + this.map).add("reference=" + this.reference).add("facets=" + this.facets).add("name='" + this.name + "'").toString();
    }
}

