/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.broker.metadata;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;

public class ClusterConfigHolder {
    private static AtomicLong configId = new AtomicLong(-2L);
    private static AtomicInteger maxMsgSize = new AtomicInteger(1058816);
    private static AtomicInteger minMemCacheSize = new AtomicInteger(0x180000);

    public static void updClusterSetting(ClientMaster.ClusterConfig clusterConfig) {
        if (clusterConfig == null) {
            return;
        }
        if (configId.get() != clusterConfig.getConfigId()) {
            Tuple2<Integer, Integer> calcResult;
            configId.set(clusterConfig.getConfigId());
            if (clusterConfig.hasMaxMsgSize() && ((Integer)(calcResult = ClusterConfigHolder.calcMaxMsgSize(clusterConfig.getMaxMsgSize())).getF0()).intValue() != maxMsgSize.get()) {
                maxMsgSize.set((Integer)calcResult.getF0());
                minMemCacheSize.set((Integer)calcResult.getF1());
            }
        }
    }

    public static long getConfigId() {
        return configId.get();
    }

    public static int getMaxMsgSize() {
        return maxMsgSize.get();
    }

    public static int getMinMemCacheSize() {
        return minMemCacheSize.get();
    }

    public static Tuple2<Integer, Integer> calcMaxMsgSize(int maxMsgSize) {
        int tmpMaxSize = MixedUtils.mid((int)maxMsgSize, (int)0x100000, (int)0x1400000) + 10240;
        int tmpMinMemCacheSize = tmpMaxSize + (tmpMaxSize % 4 + 1) * 524288;
        return new Tuple2((Object)tmpMaxSize, (Object)tmpMinMemCacheSize);
    }
}

